
<?php $__env->startSection('title', 'Blogs'); ?>
<?php $__env->startSection('content'); ?>


<head>
    <link href="//cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css">
    <script src="//cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
    <script src="https://unpkg.com/sweetalert2@7.18.0/dist/sweetalert2.all.js"></script>

</head>

<div class="app-page-title">
    <div class="page-title-wrapper">
        <div class="page-title-heading">
            <div class="page-title-icon">
                <i class="pe-7s-users icon-gradient bg-mean-fruit"> </i>
            </div>
            <div>Broadcast List</div>
            <div class="d-inline-block ml-2">
                <!-- <button class="btn btn-success" onclick="create()"><i class="glyphicon glyphicon-plus"></i>
                    Broadcaste
                </button> -->
                <a href="<?php echo url('user/broadcast/createBroadCast'); ?>" class="btn btn-success"><i class="glyphicon glyphicon-plus"></i>
                    Broadcaste
                </a>
            </div>
            <div class="d-inline-block ml-2">
                <a href="<?php echo url('user/broadcast/uploadtemplates'); ?>" class="btn btn-secondary">Refresh</a>
            </div>

        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12 col-sm-12">
        <div class="main-card mb-3 card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="manage_all" class="align-middle mb-0 table table-borderless table-striped table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th style="text-align: left;">Broadcast Name</th>
                                <th style="text-align: left;">Template Name</th>
                                <th>Time To Execuate</th>
                                <th>Execuate Status</th>
                                <th>Status</th>
                                <th>Created At</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($broadcastes as $value) : ?>
                                <tr id=<?= $value->id ?>>
                                    <td><?= $value->id ?></td>
                                    <td style="text-align: left;"><?= $value->broadcast_name ?></td>
                                    <td style="text-align: left;"><?= $value->template_name ?></td>
                                    <td><?= $value->time_to_execuate ?></td>
                                    <td><?= $value->execuate_status ?>

                                        <?php if (!$value->execuate_status) : ?>
                                            <span class="badge badge-danger">
                                                pending
                                            </span>
                                        <?php else : ?>
                                            <?= $value->execuate_status   ?>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($value->status == 1) : ?>
                                            <span class="badge badge-success">
                                                <?= $value->status == 1 ?   "Now" : "Scheduled"   ?>
                                            </span>
                                        <?php else : ?>
                                            <span class="badge badge-primary">
                                                <?= $value->status == 1 ?   "Now" : "Scheduled"   ?>
                                            </span>
                                        <?php endif; ?>

                                    </td>
                                    <td>
                                        <?= $value->created_at ?>
                                    </td>
                                    <td align="left">
                                        <!-- Example single danger button -->
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-danger dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                Action
                                            </button>
                                            <div class="dropdown-menu">
                                                <a href="<?php echo url('user/broadcast/updateBroadCast/' . $value->id); ?>" class="dropdown-item"><i class="glyphicon glyphicon-plus"></i>
                                                    Edit
                                                </a>
                                                <button class="dropdown-item" onclick="delete_broadcast(<?= $value->id ?>)"><i class="glyphicon glyphicon-plus"></i>
                                                    Delete
                                                </button>
                                                <a href="<?php echo url('user/broadcastlog/showlog/' . $value->id); ?>" class="dropdown-item"><i class="glyphicon glyphicon-plus"></i>
                                                    Logs
                                                </a>
                                            </div>
                                        </div>

                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    tr {
        text-align: center;
        vertical-align: middle;
    }

    td {
        text-align: center;
        vertical-align: middle;
    }

    @media  screen and (min-width: 768px) {
        #myModal .modal-dialog {
            width: 70%;
            border-radius: 5px;
        }
    }
</style>
<script>
    // $(function() {
    //     table = $('#manage_all').DataTable({
    //         processing: true,
    //         serverSide: true,
    //         ajax: '/admin/allBlogs',
    //         columns: [{
    //                 data: 'DT_RowIndex',
    //                 name: 'DT_RowIndex'
    //             },
    //             {
    //                 data: 'file_path',
    //                 name: 'file_path'
    //             },
    //             {
    //                 data: 'title',
    //                 name: 'title'
    //             },
    //             {
    //                 data: 'status',
    //                 name: 'status'
    //             },
    //             {
    //                 data: 'action',
    //                 name: 'action'
    //             }
    //         ],
    //         "columnDefs": [{
    //             "className": "",
    //             "targets": "_all"
    //         }],
    //         "autoWidth": false,
    //     });
    //     $('.dataTables_filter input[type="search"]').attr('placeholder', 'Type here to search...').css({
    //         'width': '220px',
    //         'height': '30px'
    //     });
    // });
</script>
<script type="text/javascript">
    function create() {
        ajax_submit_create('broadcast');
    }

    function delete_broadcast(id, ) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            console.log(result);
            if (result.value) {
                console.log('yes');
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    type: 'post',
                    url: "<?php echo e(URL::to('/user/broadcast/deleteBroadcast/')); ?>",
                    data: {
                        id,
                    },
                    success: function(data) {
                        console.log(data);
                        if (data) {
                            $('#' + id).remove();
                            // window.location.reload()
                            Swal.fire({
                                position: 'center',
                                icon: 'success',
                                title: "Broadcast has been deleted",
                                showConfirmButton: false,
                                timer: 1500
                            })
                        }
                    }

                });

            }
        })
    }

    $(document).ready(function() {

        <?php if($message = session('status')): ?>
        Swal.fire({
            position: 'center',
            icon: 'success',
            title: "<?php echo e($message); ?>",
            showConfirmButton: false,
            timer: 1500
        })
        <?php endif; ?>


        // View Form
        $('#manage_all').DataTable({
            "paging": true,
            "ordering": true,
            "order": [
                [6, 'desc'],
                [0, 'asc']
            ],
            "info": true
        });

        $("#manage_all").on("click", ".view", function() {
            var id = $(this).attr('id');
            ajax_submit_view('blogs', id)
        });

        // Edit Form
        $("#manage_all").on("click", ".edit", function() {
            var id = $(this).attr('id');
            ajax_submit_edit('blogs', id)
        });


        // Delete
        $("#manage_all").on("click", ".delete", function() {
            var id = $(this).attr('id');
            ajax_submit_delete('blogs', id)
        });

    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.user_master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\lunar\xamp7.3\htdocs\lancer\chatbox\resources\views/backend/user/broadcast/index.blade.php ENDPATH**/ ?>