-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               10.4.18-MariaDB - mariadb.org binary distribution
-- Server OS:                    Win64
-- HeidiSQL Version:             12.4.0.6659
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

-- Dumping structure for table chatbox_db.accounts
CREATE TABLE IF NOT EXISTS `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `phone_number` varchar(255) NOT NULL,
  `phone_number_id` varchar(255) NOT NULL,
  `waba_id` varchar(255) DEFAULT NULL,
  `user_access_token` varchar(255) NOT NULL,
  `api_url` varchar(255) DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `company_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_company_id_foreign` (`company_id`),
  CONSTRAINT `accounts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `company` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

-- Dumping data for table chatbox_db.accounts: ~10 rows (approximately)
INSERT INTO `accounts` (`id`, `phone_number`, `phone_number_id`, `waba_id`, `user_access_token`, `api_url`, `status`, `created_at`, `updated_at`, `company_id`) VALUES
	(1, '923013350899999', '101631739253223', '104777585599403', 'EAAQmhO2aDmMBABFHD7rhD8ZBd9nRYBRzjDTENQcPUSDzvTAYUtGi80ZBJZC1HWaWgPkwIZBumuvCNp3vD7SkGHznt8EsxglJx1VnhDppNhHJshh3AnogZARXTKF52dBBNTXZAxIsbTEzZAXTNwKNZCsHtIzQali5FmZA3pKefKJCt1BHKghO2LjikNMJZC0AMZBZCLKh3Lxjg29DZBQZDZD', 'https://graph.facebook.com/v13.0/', 1, '2022-07-13 22:13:27', NULL, 1),
	(2, '923081834220', '104777585599403', NULL, 'EAAQmhO2aDmMBABFHD7rhD8ZBd9nRYBRzjDTENQcPUSDzvTAYUtGi80ZBJZC1HWaWgPkwIZBumuvCNp3vD7SkGHznt8EsxglJx1VnhDppNhHJshh3AnogZARXTKF52dBBNTXZAxIsbTEzZAXTNwKNZCsHtIzQali5FmZA3pKefKJCt1BHKghO2LjikNMJZC0AMZBZCLKh3Lxjg29DZBQZDZD', 'https://graph.facebook.com/v13.0/', 1, '2022-07-14 01:04:29', NULL, 1),
	(3, '27663531543', '107580375355786', NULL, 'EAAUwCZAC5RrMBABMfdGodQ4onXEXmjhMCXOZBCcFnwoAW4V79mxxMhZAqdGQ2hsb5vTktDZBMfh45y2fyM7ZBJGXQOY84qrpwjLdJEk6MQWSJGnZA8ZAKRmSsXQeOsAE93B540DGwzscFjNRQAkLpcTyK4xmgVRULTP4zdcPyI9BEHMemZAutcQp', 'https://graph.facebook.com/v13.0/', 1, '2022-07-16 01:03:23', NULL, 2),
	(4, '972552673546', '100320746109651', '105637618899609', 'EAAGQRx9xHc4BAKey4LvKDVfSdITjGMoyDrhZBAnHIZCOYUVbofFZCX5AIN3BfUMpwZBCTlzm3h0nZCy6Ab9as4ZB2aHdVSuxWZBHOJsMQ0qUXChmcpwFeor72iCj1hYy5jZCgQIbe19o1TyPribGZCPmmevVOPJGJxrZAfJovZBEGazLs8wkv9fXGFn', 'https://graph.facebook.com/v13.0/', 1, '2022-07-16 02:14:30', NULL, 3),
	(5, '27685608621', '107349438717486', NULL, 'EAAF3ORPon2wBAGPFQ3XYXLiPnKX1soZBWZBWdVqpJo5ut6mxwdzHo3w34Bco44dSrjZAZBsgDR1C1qwtK0syVCCCOdco1RKsxAzJexB45eE620suRZAI5L0aQzjFrIx0DXybZBbImNGbbBaMZAVhYCROl9vUAPkbHx8VCqZAZAdGH7ZBTVxDuVq2EU', 'https://graph.facebook.com/v13.0/', 1, '2022-07-17 10:37:27', NULL, 2),
	(6, '03052143021', '100238906117303', NULL, 'EAAUsv3V4mKkBAM0iCNLtlOQp5gOukT0CLgHWUZANaGZCnJRYzXzgJIzIVUU6oZAN7it9KKjgPzoOggxmL2OJXMo1J75Ym2K3qEv80DvltU7W4mTasouh69q8Ja0rwqYAeDRTRpIWf2rsGClczuw3P5pZCtScwzWPXRb4cZAbZAA2tCZB2ZBtFxRa', 'https://graph.facebook.com/v14.0/', 1, NULL, NULL, 4),
	(7, '525587963369', '106624815475596', '101654355982163', 'EAAsdbkfsuZAUBACpoZCaZBt8HzeiP4pljZC9GAaeNz3lhSjqz91Akkvnz1ZC8KIazLUzLUjTsFWbEZCdJDewZClIrkaAKsfmW6zptxr9DedvSxiGNZBgCAQkhph06JiP4Cx20fdFGi1dVpoZCiZAo8Vwh6Gi6lry8KYdHBZBJesdKS0G3524DLQR8tmDmun8ppNoBiKYdJe53c1ZBAZDZD', 'https://graph.facebook.com/v14.0/', 1, '2022-08-04 23:05:20', NULL, 5),
	(8, '1555006797011', '113413544720992', '102575172486915', 'EAAQmhO2aDmMBANMUEEYt3UHhICyjCrv797JMuqxt6KOqF9tW40yjgvDmu2MMARWufEgbagcZBal8ZAF0D4qhdZBlG2T2WZCK6IM3wOP3vJn1lsrePEMQHUMV7yOZBsODK7UpFZBbCZAWrtDCqarYbVVYZClgxphJFPnKm5EYlW295MbNkfsm1NIsqpskQmeRDsiBRjlWK2VeIgZDZD', 'https://graph.facebook.com/v14.0/', 1, '2022-09-05 16:48:49', NULL, 1),
	(10, '918956453344', '114712751569984', '116284374744659', 'EAAMQDksM5G4BAPUP8kajQXTBlbUXHJJoYZCHS2S3UvNneSBvT4cya3lgHckl6OuPduEbEAtRx402PSPvqSmUgcj87RKkYUG7TrCuHcsKmtbyivFmZBzmp33sB5kVWQRtRvkwjbUepRoYT0eOkdNbqfTbLdF3JqMf5VZCDsMZCLBpKZBNAyVYI', 'https://graph.facebook.com/v15.0/', 1, NULL, NULL, 1),
	(11, '15550059227', '114712751569984', '116284374744659', 'EAAMQDksM5G4BAL92LpddJSZB8b0rAQiCKYvA8ZAxf0fToa2foC0PRSOZC1mZCBMT1qO0hz7ZAr3cNY8VLxJJhdZBA30MbMCx8LZCNvie8vZCSqaQtTZA7sn6xpitAZCBnpSRzgPaFgMtoGm1Tc8YOdzyklDOOPDZCXmfOZCtPnz2VKObnEZBxIRij6Vs7cgpFyTZCMxBePZCoTqSZAVcLwZDZD', 'https://graph.facebook.com/v14.0/', 1, NULL, NULL, 6);

-- Dumping structure for table chatbox_db.admins
CREATE TABLE IF NOT EXISTS `admins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `admins_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- Dumping data for table chatbox_db.admins: ~1 rows (approximately)
INSERT INTO `admins` (`id`, `name`, `email`, `email_verified_at`, `password`, `status`, `remember_token`, `created_at`, `updated_at`) VALUES
	(1, 'superadmin', 'superadmin@admin.com', NULL, '$2y$10$PqSKV7Ye2PVTzNor1tEhguuPxzY3lGTN9H4JWZqlNwK2GvjYB7OXG', 1, NULL, '2020-07-08 13:00:00', '2020-10-15 03:45:34');

-- Dumping structure for table chatbox_db.blogs
CREATE TABLE IF NOT EXISTS `blogs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` longtext NOT NULL,
  `category` varchar(200) DEFAULT NULL,
  `uploaded_by` int(11) DEFAULT 1,
  `file_path` varchar(255) DEFAULT 'assets/images/blog/default.png',
  `status` tinyint(4) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

-- Dumping data for table chatbox_db.blogs: ~17 rows (approximately)
INSERT INTO `blogs` (`id`, `title`, `description`, `category`, `uploaded_by`, `file_path`, `status`, `created_at`, `updated_at`) VALUES
	(1, 'Velit consectetur saepe adipisci pariatur laboriosam sit. Dolores qui et expedita rerum earum quia. Optio cumque quia dolor et. Doloremque provident vero suscipit.', 'Doloremque et reprehenderit tempore natus a animi. Corrupti porro ea voluptatem id. Excepturi atque aut perferendis. Consequatur sapiente qui distinctio totam eligendi.', '1', 1, 'assets/images/blog/default_news_a.jpg', 1, '2020-07-14 04:08:13', '2020-07-14 04:08:13'),
	(2, 'Iste qui est ea facere quisquam rem. Magnam saepe qui consequatur qui iste delectus alias. Aliquam iusto quas voluptas commodi molestiae.', 'Et ipsum beatae consequatur. Ut provident id aliquam debitis enim. Cupiditate aliquam qui repellendus ad saepe. Voluptate alias qui fugiat nihil aut aspernatur. Laboriosam modi et quia nihil voluptate molestias porro.', '1', 1, 'assets/images/blog/default.png', 1, '2020-07-14 04:08:13', '2020-07-14 04:08:13'),
	(3, 'Eos voluptatem dolorem laudantium facere ipsa aut. Qui illo quaerat eos recusandae culpa. Molestias et voluptates fugit ab totam laboriosam. Rem libero maxime perferendis facilis hic architecto.', 'Accusamus minima in nulla aut eos consequuntur vitae est. Ad quod ab at quo dolores porro. Voluptatem molestiae dolorem a unde nobis laudantium totam.', '1', 1, 'assets/images/blog/default.png', 1, '2020-07-14 04:08:13', '2020-07-14 04:08:13'),
	(4, 'Reiciendis dolores in sunt illo. Repudiandae deleniti soluta tempore voluptatum consectetur voluptatem perspiciatis. Rerum qui eius aut adipisci.', 'Quam aut eos ullam. Dolor et vitae aut maxime. Ducimus qui harum voluptatum deserunt dolorum corporis tempore.', '1', 1, 'assets/images/blog/default.png', 1, '2020-07-14 04:08:13', '2020-07-14 04:08:13'),
	(5, 'Vel numquam non ipsam amet dicta doloremque eligendi. Nulla rerum aut reiciendis voluptas mollitia et. Atque iste dolor animi neque consequuntur labore doloribus.', 'Dolorem unde tempora eum. Velit eum velit quia in repudiandae natus et incidunt. Corrupti eum dolor nobis est quibusdam. Velit iusto consectetur reiciendis ex aut consequuntur odit. Excepturi laborum est occaecati fugiat voluptas.', '1', 1, 'assets/images/blog/default.png', 1, '2020-07-14 04:08:13', '2020-07-14 04:08:13'),
	(6, 'Sed qui inventore voluptas iste pariatur nihil fugiat. Laboriosam nam fugiat odit temporibus et. Porro omnis quaerat nobis voluptas et cupiditate nam. Ut id eum eos. Quas voluptatem nobis rem non.', 'Assumenda vel tenetur saepe repellendus amet. Quo qui placeat aut et laborum magnam. Corporis et velit quibusdam ipsa. Alias excepturi labore et hic necessitatibus dicta.', '1', 1, 'assets/images/blog/default.png', 1, '2020-07-14 04:08:13', '2020-07-14 04:08:13'),
	(7, 'Velit at magnam libero quibusdam cum. Accusantium modi porro excepturi sit sequi. Facilis nihil inventore a qui aut.', 'Quia est numquam dolor enim eum est. Amet voluptatem est architecto voluptatem vero vitae ut.', '1', 1, 'assets/images/blog/default.png', 1, '2020-07-14 04:08:13', '2020-07-14 04:08:13'),
	(8, 'Accusamus et sit saepe ut eum. Qui error ipsum dolor optio provident error aut. Et facilis corrupti saepe. Aliquam et omnis quibusdam hic dicta.', 'Ut dolorum aut labore corrupti occaecati ipsa dolores est. Officiis ipsam dolores tenetur sequi velit rerum dolor. Magni debitis pariatur asperiores nesciunt perferendis. Molestiae autem non est veritatis.', '1', 1, 'assets/images/blog/default.png', 1, '2020-07-14 04:08:13', '2020-07-14 04:08:13'),
	(9, 'Repudiandae id aperiam est et. Delectus possimus ipsam est accusamus.', 'Ad maxime et quam sed minima sint quia. Facilis odio et voluptas earum hic quas magnam numquam. Ut debitis cupiditate eos enim.', '1', 1, 'assets/images/blog/default.png', 1, '2020-07-14 04:08:13', '2020-07-14 04:08:13'),
	(10, 'Quis pariatur porro sint vel excepturi. Delectus facilis rerum sed molestiae.', 'Quos harum officia esse sunt in qui natus nihil. Est eligendi sint possimus aut. Quis et qui repellat inventore et. Ut ut ratione id accusamus vel.', '1', 1, 'assets/images/blog/default.png', 1, '2020-07-14 04:08:13', '2020-07-14 04:08:13'),
	(14, 'Quam accusamus molestias qui optio fugiat omnis autem. Reprehenderit adipisci accusantium qui iusto sapiente sed voluptatem quasi. Laboriosam voluptas blanditiis earum amet voluptas sit.', 'Quas laboriosam corporis dolorem id itaque et. Est aut illo alias aut sint. Eaque sunt impedit mollitia nihil impedit repellat architecto.', 'Latest News', 1, 'assets/images/blog/default_news_a.jpg', 1, '2020-07-14 04:11:03', '2020-09-29 01:18:49'),
	(15, 'Et deleniti maiores eum consectetur facere inventore. Enim praesentium quo quia praesentium. Est voluptatem qui molestiae voluptas harum. Ut inventore impedit sequi vitae fugit aut est repellat.', 'Adipisci expedita fuga consequatur nobis aut suscipit iusto blanditiis. Magnam accusamus necessitatibus numquam et repellendus aut culpa consectetur. Et quod accusamus ut harum adipisci ab. Vero debitis nobis veniam quia cupiditate voluptates. Pariatur est doloremque eum voluptas incidunt vero quas et.', 'Latest News', 1, 'assets/images/blog/default_news_a.jpg', 1, '2020-07-14 04:11:03', '2020-09-29 01:19:00'),
	(16, 'Animi dignissimos natus optio voluptatum officiis. Culpa aspernatur fugit nemo non officia.', 'Mollitia voluptatem est aut similique qui commodi vitae. Est in perspiciatis eligendi eveniet sunt. Quisquam error exercitationem odit aut.', 'Latest News', 1, 'assets/images/blog/default_news_a.jpg', 1, '2020-07-14 04:11:03', '2020-09-29 02:09:46'),
	(17, 'Et sit quia veniam qui optio. Ut dolorum illum nemo error neque repellendus. Expedita atque consectetur consequatur.', 'Quas est architecto natus. Non libero repellat tempore ut excepturi recusandae a. Officiis repellendus aut neque aliquam. Tenetur aut placeat iure.', '1', 1, 'assets/images/blog/default.png', 1, '2020-07-14 04:11:03', '2020-07-14 04:11:03'),
	(18, 'Dolor consequatur repudiandae molestias dolorum hic autem corrupti. Et dolores porro totam quidem sequi et. Ab voluptas soluta qui eum assumenda.', 'Dolor provident consequatur autem dicta qui aut. Est non assumenda provident ut. Eos maiores quos molestias alias maxime omnis nisi voluptatibus. Nisi vero quam incidunt ut nobis.', '1', 1, 'assets/images/blog/default.png', 1, '2020-07-14 04:11:03', '2020-07-14 04:11:03'),
	(19, 'Perspiciatis officia qui rerum enim sit non debitis. Omnis nesciunt voluptas saepe optio labore. Dolore voluptatum qui exercitationem optio eum exercitationem.', 'Et assumenda non rerum et. Quibusdam et nam eos qui quia minima sit rerum. Perspiciatis velit impedit fuga magni voluptas voluptas blanditiis eius.', '1', 1, 'assets/images/blog/default.png', 1, '2020-07-14 04:11:03', '2020-07-14 04:11:03'),
	(20, 'Sed eaque enim rerum sapiente dolorem porro aut. Rerum quae debitis deleniti quibusdam veniam. Delectus unde nulla rerum vel sed. Accusantium quae optio animi minus est sed.', 'Corporis est optio exercitationem nesciunt velit quos iste. Consectetur praesentium aliquid ipsa ducimus reiciendis.', '1', 1, 'assets/images/blog/default.png', 1, '2020-07-14 04:11:03', '2020-07-14 04:11:03');

-- Dumping structure for table chatbox_db.botmsgs_context
CREATE TABLE IF NOT EXISTS `botmsgs_context` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `bot_msgs_id` int(11) NOT NULL,
  `bot_visitor` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `wamid_context` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table chatbox_db.botmsgs_context: ~0 rows (approximately)

-- Dumping structure for table chatbox_db.botmsgs_externalaction
CREATE TABLE IF NOT EXISTS `botmsgs_externalaction` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `bot_msgs_id` bigint(20) unsigned NOT NULL,
  `type` tinyint(4) DEFAULT NULL COMMENT '1 means email, 2 meand API call',
  `recipient` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_botmsgs_externalaction_bot_msgs` (`bot_msgs_id`),
  CONSTRAINT `FK_botmsgs_externalaction_bot_msgs` FOREIGN KEY (`bot_msgs_id`) REFERENCES `bot_msgs` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table chatbox_db.botmsgs_externalaction: ~1 rows (approximately)
INSERT INTO `botmsgs_externalaction` (`id`, `bot_msgs_id`, `type`, `recipient`, `status`, `created_at`, `updated_at`) VALUES
	(1, 41, 2, '923458095076', 1, '2023-02-01 14:18:52', '2023-02-01 14:18:53');

-- Dumping structure for table chatbox_db.botmsgs_fomula_values
CREATE TABLE IF NOT EXISTS `botmsgs_fomula_values` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fk_botmsg_formula` int(10) unsigned NOT NULL,
  `fk_visitor_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `fk_bot_info_id` int(10) unsigned NOT NULL,
  `value` varchar(50) NOT NULL DEFAULT '',
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `FK_botmsgs_fomula_values_botmsgs_formula` (`fk_botmsg_formula`),
  KEY `FK_botmsgs_fomula_values_bot_visitors` (`fk_visitor_id`),
  KEY `FK_botmsgs_fomula_values_bot_info` (`fk_bot_info_id`),
  CONSTRAINT `FK_botmsgs_fomula_values_bot_info` FOREIGN KEY (`fk_bot_info_id`) REFERENCES `bot_info` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_botmsgs_fomula_values_bot_visitors` FOREIGN KEY (`fk_visitor_id`) REFERENCES `bot_visitors` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_botmsgs_fomula_values_botmsgs_formula` FOREIGN KEY (`fk_botmsg_formula`) REFERENCES `botmsgs_formula` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=137 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table chatbox_db.botmsgs_fomula_values: ~0 rows (approximately)

-- Dumping structure for table chatbox_db.botmsgs_formula
CREATE TABLE IF NOT EXISTS `botmsgs_formula` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL,
  `msg_id` varchar(50) NOT NULL,
  `status` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table chatbox_db.botmsgs_formula: ~7 rows (approximately)
INSERT INTO `botmsgs_formula` (`id`, `name`, `msg_id`, `status`, `created_at`) VALUES
	(1, 'LUMSUM_CALC', '52', '1', '2023-03-21 09:45:18'),
	(2, 'SIP_CALCU', '54', '1', '2023-03-22 15:10:32'),
	(3, 'RISK_CATEGORY', '54', '1', '2023-03-22 15:10:42'),
	(4, 'SIP_DYNAMIC', '56', '1', '2023-03-22 19:16:00'),
	(5, 'SYP_DYNAMIC_SHORTFALL', '56', '1', '2023-03-23 08:02:31'),
	(6, 'PRESENT_VALUE', '57', '1', '2023-03-23 13:13:56'),
	(7, 'YEARS_PLAN', '50', '1', '2023-03-24 12:20:27');

-- Dumping structure for table chatbox_db.bot_actors
CREATE TABLE IF NOT EXISTS `bot_actors` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned DEFAULT NULL,
  `actor_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bot_actors_account_id_foreign` (`account_id`),
  CONSTRAINT `bot_actors_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table chatbox_db.bot_actors: ~7 rows (approximately)
INSERT INTO `bot_actors` (`id`, `account_id`, `actor_name`, `status`, `created_at`, `updated_at`) VALUES
	(1, 1, 'Driver', 1, '2022-08-10 01:33:08', NULL),
	(2, 1, 'Shipper', 1, '2022-08-10 01:33:37', NULL),
	(3, 1, 'Both', 1, '2022-08-13 03:42:35', NULL),
	(4, 8, 'Driver', 1, '2022-09-05 16:50:19', NULL),
	(5, 8, 'Shipper', 1, '2022-09-05 16:50:31', NULL),
	(6, 8, 'Both', 1, '2022-09-05 16:50:41', NULL),
	(7, 10, 'Both', 1, '2023-01-31 12:10:15', NULL);

-- Dumping structure for table chatbox_db.bot_info
CREATE TABLE IF NOT EXISTS `bot_info` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) unsigned DEFAULT NULL,
  `name` varchar(250) DEFAULT '0',
  `bot_timeout_hr` varchar(250) DEFAULT '0',
  `when_triggered` tinyint(4) DEFAULT 0 COMMENT '1 mean always triggered, 2 means exact matching, 3 means contain matching',
  `status` varchar(250) DEFAULT '0',
  `created_at` varchar(250) NOT NULL,
  `updated_at` varchar(250) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_bot_info_accounts` (`account_id`),
  CONSTRAINT `FK_bot_info_accounts` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table chatbox_db.bot_info: ~2 rows (approximately)
INSERT INTO `bot_info` (`id`, `account_id`, `name`, `bot_timeout_hr`, `when_triggered`, `status`, `created_at`, `updated_at`) VALUES
	(1, 10, 'sbux', '24', 1, '1', '', ''),
	(2, 11, 'Amol', '24', 1, '1', '', '');

-- Dumping structure for table chatbox_db.bot_language
CREATE TABLE IF NOT EXISTS `bot_language` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `bot_language` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table chatbox_db.bot_language: ~4 rows (approximately)
INSERT INTO `bot_language` (`id`, `bot_language`, `status`, `created_at`, `updated_at`) VALUES
	(1, 'English', 1, '2022-08-13 05:51:41', NULL),
	(2, 'Arabic', 1, '2022-08-13 05:51:49', NULL),
	(3, 'Urdu', 1, '2022-08-13 05:51:57', NULL),
	(4, 'General', 1, '2022-08-13 05:52:03', NULL);

-- Dumping structure for table chatbox_db.bot_msgs
CREATE TABLE IF NOT EXISTS `bot_msgs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `actor_id` bigint(20) unsigned DEFAULT NULL,
  `fk_bot_info` int(10) unsigned DEFAULT NULL,
  `sequence` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_last_sequence` tinyint(4) DEFAULT NULL,
  `coming_answ` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `language` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_template` tinyint(4) DEFAULT NULL,
  `template_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_externalaction` tinyint(4) DEFAULT NULL,
  `is_context_check` tinyint(4) DEFAULT NULL,
  `template_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bot_msgs_actor_id_foreign` (`actor_id`),
  KEY `fk_bot_info` (`fk_bot_info`),
  CONSTRAINT `bot_msgs_actor_id_foreign` FOREIGN KEY (`actor_id`) REFERENCES `bot_actors` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_bot_info` FOREIGN KEY (`fk_bot_info`) REFERENCES `bot_info` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table chatbox_db.bot_msgs: ~21 rows (approximately)
INSERT INTO `bot_msgs` (`id`, `actor_id`, `fk_bot_info`, `sequence`, `is_last_sequence`, `coming_answ`, `language`, `is_template`, `template_id`, `is_externalaction`, `is_context_check`, `template_name`, `text`, `type`, `status`, `created_at`, `updated_at`) VALUES
	(36, 4, 1, '0', 0, NULL, '4', 0, NULL, NULL, NULL, NULL, 'Welcome to the Kiran Jadhav and Associates', '1', 1, '2023-01-31 12:12:48', NULL),
	(37, 4, 1, '0', NULL, NULL, '4', 0, NULL, NULL, NULL, NULL, 'Do you accept our terms and conditions?\r\n\r\nhttps://www.kiranjadhav.com/disclaimer.php', '3', 1, '2023-01-31 13:07:43', NULL),
	(38, 7, 1, '', NULL, '37.1', '1', 0, NULL, NULL, NULL, NULL, 'Please write your name.', '1', 1, '2023-01-31 14:06:38', NULL),
	(40, 7, 1, '1', 0, '', '1', 0, NULL, NULL, NULL, NULL, 'Please input your cell number(Numbers only)', '1', 1, '2023-01-31 14:56:05', '2023-01-31 14:56:11'),
	(41, 7, 1, '2', NULL, '', '1', 0, NULL, 1, 0, '', 'Kindly enter OTP received on your number given above', '1', 1, '2023-02-01 08:55:38', NULL),
	(42, 7, 1, '', NULL, '1234', '1', 0, NULL, 0, 0, NULL, 'Enter State', '4', 1, '2023-02-02 10:11:22', '2023-02-02 10:11:23'),
	(44, NULL, 1, NULL, NULL, '37.2', '1', 0, NULL, NULL, NULL, NULL, 'Thanks for being here. Please follow us.', NULL, NULL, NULL, NULL),
	(45, NULL, 1, NULL, NULL, '42.1', '1', 0, NULL, NULL, 0, NULL, 'Select City', '2', 1, '2023-03-17 09:12:37', '2023-03-17 09:12:38'),
	(46, NULL, 1, NULL, NULL, '42.2', '1', 0, NULL, NULL, NULL, NULL, 'Select City', '2', 1, '2023-03-17 09:14:20', NULL),
	(47, NULL, 1, NULL, NULL, '42.3', '1', 0, NULL, NULL, NULL, NULL, 'Select City', '2', 1, '2023-03-17 09:14:16', NULL),
	(48, NULL, 1, NULL, NULL, '42.4', '1', 0, NULL, NULL, NULL, NULL, 'Select City', '2', 1, '2023-03-17 09:14:44', '2023-03-17 09:14:45'),
	(49, NULL, 1, NULL, NULL, '45,46', '1', 0, NULL, NULL, NULL, NULL, 'What kind of dream are you looking for?', '2', 1, '2023-03-17 11:30:30', NULL),
	(50, NULL, 1, NULL, NULL, '49', '1', 0, NULL, NULL, NULL, NULL, 'Time frame of this dream?', '2', 1, '2023-03-17 13:40:33', NULL),
	(51, NULL, 1, '', NULL, '50', '1', 0, NULL, NULL, NULL, NULL, 'What is the present cost of your dream (@@@49.1|49.2|49.3@@@)?', '1', 1, '2023-03-18 16:23:53', NULL),
	(52, NULL, 1, '3', NULL, NULL, '1', 0, NULL, 0, NULL, NULL, 'Future value after @@@50.1|50.2|50.3|50.4|50.5|50.6|50.7|50.8|50.9@@@ for this dream would be INR.{{LUMSUM_CALC}}', '1', 1, '2023-03-18 16:41:06', NULL),
	(53, NULL, 1, '3', NULL, NULL, '1', 0, NULL, 0, NULL, NULL, 'How do you want to invest to make your dream cheaper? ', '2', 1, '2023-03-22 08:55:40', NULL),
	(54, NULL, 1, NULL, NULL, '53.1', '1', NULL, NULL, NULL, NULL, NULL, 'We recommend you to start SIP of Rs.{{SIP_CALCU}} in {{RISK_CATEGORY}} mutual funds', '1', 1, NULL, NULL),
	(55, NULL, 1, NULL, NULL, '53.1', '1', NULL, NULL, NULL, NULL, NULL, 'How much amount you can invest per month?', '1', 1, '2023-03-22 19:11:33', NULL),
	(56, NULL, 1, '4', NULL, NULL, '1', NULL, NULL, NULL, NULL, NULL, 'Your expected corpus after {{YEARS_PLAN}} would be Rs. {{SIP_DYNAMIC}}. Hence your shortfall for target amount is Rs.{{SYP_DYNAMIC_SHORTFALL}}. Do you want to cover this shortfall? ', '3', 1, '2023-03-22 19:12:58', NULL),
	(57, NULL, 1, NULL, NULL, '56.1', '1', NULL, NULL, NULL, NULL, NULL, 'we recommend you to do Rs. {{PRESENT_VALUE}} one time investment.', '1', 1, '2023-03-23 13:18:31', NULL),
	(58, NULL, 1, NULL, NULL, '56.2', '1', NULL, NULL, NULL, NULL, NULL, 'our representative will be in touch with you. Thanks for contacting Kiran Jadhav and Associates ', '1', 1, NULL, NULL);

-- Dumping structure for table chatbox_db.bot_msgs_options
CREATE TABLE IF NOT EXISTS `bot_msgs_options` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `msgs_id` bigint(20) unsigned DEFAULT NULL,
  `option_text` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valid_answer` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `option_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bot_msgs_options_msgs_id_foreign` (`msgs_id`)
) ENGINE=InnoDB AUTO_INCREMENT=357 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table chatbox_db.bot_msgs_options: ~54 rows (approximately)
INSERT INTO `bot_msgs_options` (`id`, `msgs_id`, `option_text`, `valid_answer`, `option_type`, `status`, `created_at`, `updated_at`) VALUES
	(1, 6, 'T-1', '6.1', NULL, 1, '2022-08-12 11:38:07', NULL),
	(304, 37, 'Yes', '37.1', NULL, 1, '2023-01-31 13:10:42', '2023-01-31 13:10:43'),
	(305, 37, 'No', '37.2', NULL, 1, '2023-01-31 13:10:56', '2023-01-31 13:10:56'),
	(306, 42, '14', '42.1', '', 1, '2023-03-17 08:33:29', '2023-03-17 08:33:30'),
	(307, 42, '15', '42.2', NULL, 1, '2023-03-17 08:34:02', '2023-03-17 08:34:02'),
	(308, 42, '16', '42.3', NULL, 1, '2023-03-17 08:34:17', '2023-03-17 08:34:17'),
	(309, 42, '17', '42.4', NULL, 1, '2023-03-17 08:40:38', NULL),
	(310, 45, 'Amritsar', '45.1', NULL, 1, '2023-03-17 09:24:12', NULL),
	(311, 45, 'Ludhiana', '45.2', NULL, 1, '2023-03-17 09:24:40', NULL),
	(312, 45, 'Jalandhar', '45.3', NULL, 1, '2023-03-17 09:25:04', NULL),
	(313, 45, 'Patiala', '45.4', NULL, 1, '2023-03-17 09:25:36', NULL),
	(314, 45, 'Kapurthala', '45.5', NULL, 1, '2023-03-17 09:26:00', NULL),
	(315, 45, 'Bathinda', '45.6', NULL, 1, '2023-03-17 09:26:19', NULL),
	(316, 45, 'Hoshiarpur', '45.7', NULL, 1, '2023-03-17 09:26:39', NULL),
	(317, 45, 'Sri Muktsar Sahib', '45.8', NULL, 1, '2023-03-17 09:28:19', NULL),
	(318, 45, 'Others', '45.9', NULL, 1, '2023-03-17 09:28:06', NULL),
	(319, 46, 'Lucknow', '46.1', NULL, 1, '2023-03-17 10:30:02', NULL),
	(320, 46, 'Varanasi', '46.2', NULL, 1, '2023-03-17 10:30:27', NULL),
	(321, 46, 'Kanpur', '46.3', NULL, 1, '2023-03-17 10:30:46', NULL),
	(322, 46, 'Ghaziabad', '46.4', NULL, 1, '2023-03-17 10:31:11', NULL),
	(323, 46, 'Prayagraj', '46.5', NULL, 1, '2023-03-17 10:31:38', NULL),
	(324, 46, 'Jhansi', '46.6', NULL, 1, '2023-03-17 10:31:57', NULL),
	(325, 46, 'Firozabad', '46.7', NULL, 1, '2023-03-17 10:32:19', NULL),
	(326, 46, 'Meerut', '46.8', NULL, 1, '2023-03-17 10:32:48', NULL),
	(327, 46, 'Others', '46.9', NULL, 1, '2023-03-17 10:33:07', NULL),
	(328, 49, 'Buying a car ', '49.1', NULL, 1, '2023-03-17 11:26:02', NULL),
	(329, 49, 'Higher education ', '49.2', NULL, 1, '2023-03-17 11:26:21', NULL),
	(330, 49, 'Down payment for flat', '49.3', NULL, 1, '2023-03-17 11:26:42', NULL),
	(331, 49, 'foreign trip', '49.4', NULL, 1, '2023-03-17 11:27:03', NULL),
	(332, 50, '1 Year', '50.1', NULL, 1, '2023-03-17 13:44:41', NULL),
	(333, 50, '2  Years', '50.2', NULL, 1, '2023-03-18 16:04:39', NULL),
	(334, 50, '3 Years', '50.3', NULL, 1, '2023-03-18 16:06:38', '2023-03-18 16:06:38'),
	(335, 50, '4 Years', '50.4', NULL, 1, '2023-03-18 16:07:04', NULL),
	(336, 50, '5 Years', '50.5', NULL, 1, '2023-03-18 16:07:34', NULL),
	(337, 50, '6 Years', '50.6', NULL, 1, NULL, NULL),
	(338, 50, '7 Years', '50.7', NULL, 1, NULL, NULL),
	(339, 50, '8 Years', '50.8', NULL, 1, NULL, NULL),
	(340, 50, '9 Years', '50.9', NULL, 1, '2023-03-18 16:09:13', NULL),
	(341, 50, '10 Years', '50.10', NULL, 1, NULL, NULL),
	(342, 50, '11 Years', '50.11', NULL, 0, NULL, NULL),
	(343, 50, '12 Years', '50.12', NULL, 0, NULL, NULL),
	(344, 50, '13 Years', '50.13', NULL, 0, '2023-03-18 16:12:04', NULL),
	(345, 50, '14 Years', '50.14', NULL, 0, NULL, NULL),
	(346, 50, '15 Years', '50.15', NULL, 0, NULL, NULL),
	(347, 50, '16 Years', '50.16', NULL, 0, '2023-03-18 16:15:16', NULL),
	(348, 50, '17 Years', '50.17', NULL, 0, '2023-03-18 16:15:43', '2023-03-18 16:15:50'),
	(349, 50, '18 Years', '50.18', NULL, 0, NULL, NULL),
	(350, 50, '19 Years', '50.19', NULL, 0, '2023-03-18 16:16:45', NULL),
	(351, 50, '20 Years', '50.20', NULL, 0, '2023-03-18 16:17:11', NULL),
	(352, 50, 'Others', '50.21', NULL, 0, NULL, NULL),
	(353, 53, 'Monthly', '53.1', NULL, 1, '2023-03-22 08:56:21', NULL),
	(354, 53, 'Yearly', '53.2', NULL, 1, '2023-03-22 08:56:43', NULL),
	(355, 56, 'Yes', '56.1', NULL, 1, '2023-03-22 19:14:42', NULL),
	(356, 56, 'No', '56.2', NULL, 1, '2023-03-22 19:15:01', NULL);

-- Dumping structure for table chatbox_db.bot_regions
CREATE TABLE IF NOT EXISTS `bot_regions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lang_id` bigint(20) unsigned NOT NULL,
  `region` varchar(50) NOT NULL,
  `region_name` varchar(100) DEFAULT NULL,
  `cities` varchar(100) DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `update_at` datetime NOT NULL,
  `created_id` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table chatbox_db.bot_regions: ~17 rows (approximately)
INSERT INTO `bot_regions` (`id`, `lang_id`, `region`, `region_name`, `cities`, `status`, `created_at`, `update_at`, `created_id`) VALUES
	(1, 1, 'Riyadh Province', 'Riyadh, Kharj', 'Wadi Dawasir, Diriyah, Duwadmi, Quwaiiyah, Aflaj, Zulfi, Afif, Etc.', 1, '2011-09-22 11:17:00', '0000-00-00 00:00:00', '1\r'),
	(2, 1, 'Makkah  Province', 'Makkah, Jeddah', 'Taif, Qunfudhah, Lith, Rabigh, Jumum, Khulais, Ranyah, Turbah, Etc.', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '\r'),
	(3, 1, 'Madinah Province', 'Madinah, Yanbu', 'Al-Ula, Mahd Al-Dhahab, Badr, Khaybar, Al-Henakiyah, Etc.', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '\r'),
	(4, 1, 'Qassim Province', 'Buraydah, Unayzah', 'Ar-Rass, Al-Mithnab, Al-Bukayriyah, Al-Badayea, Etc.', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '\r'),
	(5, 1, 'Eastern Province', 'Dammam, Al-Ahsa', 'Hofuf, Hafar Al-Batin, Jubail, Qatif, Khobar, Khafji, Etc.', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '\r'),
	(6, 1, 'Asir Province', 'Abha, Bisha', 'Khamis Mushait, Al-Namas, Muhayil, Tathleeth, Dhahran Al-Janub, Etc.', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '\r'),
	(7, 1, 'Tabuk Province', 'Tabuk, Al Wajh', 'Duba, Tayma, Umluj, Haql, Etc.', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '\r'),
	(8, 1, 'Hail Province', 'Hail, Baqaa', 'Al-Ghazalah, Ash Shinan, Etc.', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '\r'),
	(9, 1, 'Northern Borders Province', 'Arar, Rafha,', 'Turaif, Etc.', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '\r'),
	(10, 1, 'Jazan Province', 'Jazan, Sabya', 'Abu Arish, Samtah, Baish, Ad Darb, Etc.', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '\r'),
	(11, 1, 'Najran Province', 'Najran, Sharorah', 'Al-Kharkhir, Etc.', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '\r'),
	(12, 1, 'Al-Bahah Province', 'Al-Bahah, Baljurashi,', 'Al-mandaq, Al-Makhwah, Al-Aqiq, Qilwah, Etc.', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '\r'),
	(13, 1, 'Al-Jawf Province', 'Al-Jawf, Sakaka', 'Qurayyat, Dumah Al-Jandal, Etc.', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '\r'),
	(14, 1, 'Punjab', 'Punjab', 'Amritsar, Ludhiana, Jalandhar, Kapurthala, Sri Muktsar Sahib', 1, '2023-03-17 08:36:04', '0000-00-00 00:00:00', ''),
	(15, 1, 'Uttar Pradesh', 'Uttar Pradesh', 'Lucknow, Varanasi, Gorakhpur, Prayagraj, Jhansi', 1, '2023-03-17 08:37:39', '0000-00-00 00:00:00', ''),
	(16, 1, 'Maharashtra', 'Maharashtra', 'Mumbai, Pune, Nagpur, Aurangabad, Kolhapur', 1, '2023-03-17 08:39:19', '0000-00-00 00:00:00', ''),
	(17, 1, 'Gujarat', 'Gujarat', 'Ahmedabad, Surat, Vadodara, Rajkot, Gandhinagar', 1, '2023-03-17 08:40:25', '0000-00-00 00:00:00', '');

-- Dumping structure for table chatbox_db.bot_variables
CREATE TABLE IF NOT EXISTS `bot_variables` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL DEFAULT '',
  `value` varchar(500) NOT NULL DEFAULT '',
  `fk_bot_info` int(11) unsigned NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `FK_bot_variables_bot_info` (`fk_bot_info`),
  CONSTRAINT `FK_bot_variables_bot_info` FOREIGN KEY (`fk_bot_info`) REFERENCES `bot_info` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4;

-- Dumping data for table chatbox_db.bot_variables: ~6 rows (approximately)
INSERT INTO `bot_variables` (`id`, `name`, `value`, `fk_bot_info`, `status`, `created_at`) VALUES
	(1, 'CAR_INTEREST', '0.02', 1, 1, '2023-03-21 15:19:39'),
	(2, 'EDUCATION_ITEREST', '0.08', 1, 1, '2023-03-21 15:19:44'),
	(3, 'FLAT_INTEREST', '0.05', 1, 1, '2023-03-21 15:19:49'),
	(12, 'TRIP_INTEREST', '0.06', 1, 1, '2023-03-21 15:19:53'),
	(13, 'MODERATE_CATEGORY', '0.08', 1, 1, '2023-03-23 06:16:14'),
	(14, 'AGGRESIVE_CATEGORY', '0.13', 1, 1, '2023-03-22 09:19:38');

-- Dumping structure for table chatbox_db.bot_visitors
CREATE TABLE IF NOT EXISTS `bot_visitors` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` bigint(20) unsigned DEFAULT NULL,
  `fk_bot_info` int(11) unsigned DEFAULT NULL,
  `session_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bot_visitors_contact_id_foreign` (`contact_id`),
  KEY `FK_bot_visitors_bot_info` (`fk_bot_info`),
  CONSTRAINT `FK_bot_visitors_bot_info` FOREIGN KEY (`fk_bot_info`) REFERENCES `bot_info` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `bot_visitors_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=369 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table chatbox_db.bot_visitors: ~0 rows (approximately)

-- Dumping structure for table chatbox_db.bot_visitors_history
CREATE TABLE IF NOT EXISTS `bot_visitors_history` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `visitor_id` bigint(20) unsigned DEFAULT NULL,
  `sequence` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `msg_id` bigint(20) unsigned DEFAULT NULL,
  `text` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visitor_language` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visitor_actor` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `wamid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `return_timestamp` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bot_visitors_history_msg_id_foreign` (`msg_id`),
  KEY `bot_visitors_history_visitor_id_foreign` (`visitor_id`),
  CONSTRAINT `bot_visitors_history_msg_id_foreign` FOREIGN KEY (`msg_id`) REFERENCES `bot_msgs` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `bot_visitors_history_visitor_id_foreign` FOREIGN KEY (`visitor_id`) REFERENCES `bot_visitors` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=1377 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table chatbox_db.bot_visitors_history: ~0 rows (approximately)

-- Dumping structure for table chatbox_db.bot_visitors_reasult
CREATE TABLE IF NOT EXISTS `bot_visitors_reasult` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `visitor_contact_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visitor_visit_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visitor_lang` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visitor_actor` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visitor_truck_type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visitor_shipping_type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visitor_schedule` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visitor_rout` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table chatbox_db.bot_visitors_reasult: ~0 rows (approximately)

-- Dumping structure for table chatbox_db.broadcaste
CREATE TABLE IF NOT EXISTS `broadcaste` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `broadcast_name` varchar(255) NOT NULL,
  `template_id` varchar(255) NOT NULL,
  `csv_name` text NOT NULL,
  `csv_path` varchar(255) NOT NULL,
  `media_name` text NOT NULL,
  `media_path` text NOT NULL,
  `time_to_execuate` timestamp NULL DEFAULT current_timestamp(),
  `execuate_status` tinyint(4) DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `created_id` varchar(100) DEFAULT NULL,
  `account_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8;

-- Dumping data for table chatbox_db.broadcaste: ~53 rows (approximately)
INSERT INTO `broadcaste` (`id`, `broadcast_name`, `template_id`, `csv_name`, `csv_path`, `media_name`, `media_path`, `time_to_execuate`, `execuate_status`, `status`, `created_id`, `account_id`, `created_at`, `updated_at`) VALUES
	(35, 'ddd', '353', '0params.xlsx', 'storage/app/docs/attachments/1658553709-0params.xlsx', '0params.xlsx', 'storage/app/docs/header_attachments/1658553709-0params.xlsx', '2022-07-23 23:21:00', NULL, 2, '1', 1, '2022-07-23 23:21:49', '2022-07-23 23:22:42'),
	(36, 'zfcv', '356', '6params.xlsx', 'storage/app/docs/attachments/1658555863-6params.xlsx', '', '', '2022-07-23 23:56:00', NULL, 1, '1', 1, '2022-07-23 23:57:43', NULL),
	(37, 'fgkdfk', '356', '6params.xlsx', 'storage/app/docs/attachments/1658555899-6params.xlsx', '', '', '2022-07-23 23:57:00', NULL, 1, '1', 1, '2022-07-23 23:58:19', NULL),
	(38, 'dddd', '383', '1params.xlsx', 'storage/app/docs/attachments/1658559909-1params.xlsx', '', '', '2022-07-23 13:00:00', NULL, 1, '1', 1, '2022-07-24 01:05:09', NULL),
	(39, 'boucher', '352', '0params.xlsx', 'storage/app/docs/attachments/1658751872-0params.xlsx', '', '', '2022-07-26 06:21:00', NULL, 1, '1', 1, '2022-07-26 06:24:32', NULL),
	(40, 'hello_world', '462', '0params.xlsx', 'storage/app/docs/attachments/1658904176-0params.xlsx', '', '', '2022-07-28 00:42:00', NULL, 1, '1', 1, '2022-07-28 00:42:56', NULL),
	(41, 'ddddx', '462', '0params.xlsx', 'storage/app/docs/attachments/1-1658910895-0params.xlsx', '', '', '2022-07-28 02:34:00', NULL, 1, '1', 1, '2022-07-28 02:34:55', NULL),
	(42, 'kdkfkdd', '462', '0params.xlsx', 'storage/app/docs/attachments/1-1658911154-0params.xlsx', '', '', '2022-07-28 02:39:00', NULL, 1, '1', 1, '2022-07-28 02:39:14', NULL),
	(43, 'dfdvd', '462', '0params.xlsx', 'storage/app/docs/attachments/1-1658911259-0params.xlsx', '', '', '2022-07-28 02:40:00', NULL, 1, '1', 1, '2022-07-28 02:40:59', NULL),
	(44, 'dfdvd', '462', '0params.xlsx', 'storage/app/docs/attachments/1-1658911289-0params.xlsx', '', '', '2022-07-28 02:40:00', NULL, 1, '1', 1, '2022-07-28 02:41:29', NULL),
	(45, 'dfdvd', '462', '0params.xlsx', 'storage/app/docs/attachments/1-1658911300-0params.xlsx', '', '', '2022-07-28 02:40:00', NULL, 1, '1', 1, '2022-07-28 02:41:40', NULL),
	(46, 'dfdvd', '462', '0params.xlsx', 'storage/app/docs/attachments/1-1658911316-0params.xlsx', '', '', '2022-07-28 02:40:00', NULL, 1, '1', 1, '2022-07-28 02:41:56', NULL),
	(47, 'kdkjdkkd', '464', '3params.xlsx', 'storage/app/docs/attachments/1-1659084761-3params.xlsx', '', '', '2022-07-30 02:52:00', NULL, 1, '1', 1, '2022-07-30 02:52:41', NULL),
	(48, 'kdkjdkkd', '464', '3params.xlsx', 'storage/app/docs/attachments/1-1659084812-3params.xlsx', '', '', '2022-07-30 02:52:00', NULL, 1, '1', 1, '2022-07-30 02:53:32', NULL),
	(49, 'kdkjdkkddd', '464', '3params.xlsx', 'storage/app/docs/attachments/1-1659085093-3params.xlsx', '', '', '2022-07-30 02:57:00', NULL, 1, '1', 1, '2022-07-30 02:58:13', NULL),
	(50, 'hrg', '462', '3params.xlsx', 'storage/app/docs/attachments/1-1659085579-3params.xlsx', '', '', '2022-07-30 02:57:00', NULL, 1, '1', 1, '2022-07-30 03:06:19', NULL),
	(51, 'kdkjdkkds', '462', '0params.xlsx', 'storage/app/docs/attachments/1-1659085609-0params.xlsx', '', '', '2022-07-29 13:00:00', NULL, 1, '1', 1, '2022-07-30 03:06:49', NULL),
	(52, 'kdkjdkkdsdsf', '462', '0params.xlsx', 'storage/app/docs/attachments/1-1659085645-0params.xlsx', '', '', '2022-07-29 13:00:00', NULL, 1, '1', 1, '2022-07-30 03:07:25', NULL),
	(53, 'kdkfkd3', '462', '0params.xlsx', 'storage/app/docs/attachments/1-1659089634-0params.xlsx', '', '', '2022-07-30 04:13:00', NULL, 1, '1', 1, '2022-07-30 04:13:54', NULL),
	(54, 'kdkfkd3', '462', '0params.xlsx', 'storage/app/docs/attachments/1-1659089808-0params.xlsx', '', '', '2022-07-30 04:13:00', NULL, 1, '1', 1, '2022-07-30 04:16:48', NULL),
	(55, 'ddd7u', '462', '0params.xlsx', 'storage/app/docs/attachments/1-1659089890-0params.xlsx', '', '', '2022-07-30 04:17:00', NULL, 1, '1', 1, '2022-07-30 04:18:10', NULL),
	(56, 'ddd7u6', '462', '0params.xlsx', 'storage/app/docs/attachments/1-1659089951-0params.xlsx', '', '', '2022-07-30 04:18:00', NULL, 1, '1', 1, '2022-07-30 04:19:11', NULL),
	(57, 'kdkfkdef', '720', '1params.xlsx', 'storage/app/docs/attachments/1-1659090592-1params.xlsx', '', '', '2022-07-30 04:29:00', NULL, 1, '1', 1, '2022-07-30 04:29:52', NULL),
	(58, 'pascal', '689', '0params.xlsx', 'storage/app/docs/attachments/1-1659108060-0params.xlsx', '', '', '2022-07-30 09:20:00', NULL, 1, '1', 1, '2022-07-30 09:21:00', NULL),
	(59, 'ddd', '775', '0params.xlsx', 'storage/app/docs/attachments/4-1659250506-0params.xlsx', '', '', '2022-08-01 00:54:00', NULL, 1, '3', 4, '2022-08-01 00:55:06', NULL),
	(60, 'ddd', '802', '0params.xlsx', 'storage/app/docs/attachments/6-1659252634-0params.xlsx', '', '', '2022-08-01 01:30:00', NULL, 1, '4', 6, '2022-08-01 01:30:34', NULL),
	(61, 'ldp', '689', '0params.xlsx', 'storage/app/docs/attachments/1-1659252733-0params.xlsx', '', '', '2022-08-01 01:32:00', NULL, 1, '1', 1, '2022-08-01 01:32:13', NULL),
	(62, 'kj', '689', '0params.xlsx', 'storage/app/docs/attachments/1-1659253265-0params.xlsx', '', '', '2022-08-01 01:40:00', NULL, 1, '1', 1, '2022-08-01 01:41:05', NULL),
	(63, 'jmlk', '689', '0params.xlsx', 'storage/app/docs/attachments/1-1659253540-0params.xlsx', '', '', '2022-08-01 01:45:00', NULL, 1, '1', 1, '2022-08-01 01:45:40', NULL),
	(64, 'dkfj', '776', '0params.xlsx', 'storage/app/docs/attachments/4-1659253905-0params.xlsx', '', '', '2022-08-01 01:51:00', NULL, 1, '3', 4, '2022-08-01 01:51:45', NULL),
	(65, 'd.fv,', '689', '0params.xlsx', 'storage/app/docs/attachments/1-1659254040-0params.xlsx', '', '', '2022-08-01 01:53:00', NULL, 1, '1', 1, '2022-08-01 01:54:00', NULL),
	(66, 'dfdf', '853', '0params.xlsx', 'storage/app/docs/attachments/4-1659254409-0params.xlsx', '', '', '2022-08-01 01:59:00', NULL, 1, '3', 4, '2022-08-01 02:00:09', NULL),
	(67, 'dd', '689', '0params.xlsx', 'storage/app/docs/attachments/1-1659350646-0params.xlsx', '', '', '2022-08-02 04:43:00', NULL, 1, '1', 1, '2022-08-02 04:44:07', NULL),
	(68, 'kdkjdkkdc', '694', '1params.xlsx', 'storage/app/docs/attachments/1-1659451907-1params.xlsx', '', '', '2022-08-03 08:51:00', NULL, 1, '1', 1, '2022-08-03 08:51:47', NULL),
	(69, 'dfvk', '694', '1params.xlsx', 'storage/app/docs/attachments/1-1659451961-1params.xlsx', '', '', '2022-08-03 08:52:00', NULL, 1, '1', 1, '2022-08-03 08:52:41', NULL),
	(70, 'klfj', '859', '1params.xlsx', 'storage/app/docs/attachments/1-1659452560-1params.xlsx', '', '', '2022-08-02 13:00:00', NULL, 1, '1', 1, '2022-08-03 09:02:40', NULL),
	(71, 'dg34ref', '872', '1params.xlsx', 'storage/app/docs/attachments/1-1659514270-1params.xlsx', '', '', '2022-08-03 13:00:00', NULL, 1, '1', 1, '2022-08-04 02:11:10', NULL),
	(72, 'kdkjdkkddf', '872', '1params.xlsx', 'storage/app/docs/attachments/1-1659514372-1params.xlsx', '', '', '2022-08-04 02:12:00', NULL, 1, '1', 1, '2022-08-04 02:12:52', NULL),
	(73, 'dddddf', '872', '1params.xlsx', 'storage/app/docs/attachments/1-1659514452-1params.xlsx', '', '', '2022-08-04 02:13:00', NULL, 1, '1', 1, '2022-08-04 02:14:12', NULL),
	(74, 'dfgd', '889', '0params.xlsx', 'storage/app/docs/attachments/4-1659522339-0params.xlsx', '', '', '2022-08-04 04:25:00', NULL, 1, '3', 4, '2022-08-04 04:25:39', NULL),
	(75, 'zmbi', '915', '4-1659532846-מילוי מספרים לשליחת הודעת שידור בווצאפ777.xlsx', 'storage/app/docs/attachments/1-1659537743-4-1659532846-מילוי מספרים לשליחת הודעת שידור בווצאפ777.xlsx', '', '', '2022-08-04 08:42:00', NULL, 1, '1', 1, '2022-08-04 08:42:23', NULL),
	(76, 'kdjfkj', '915', '4-1659532846-מילוי מספרים לשליחת הודעת שידור בווצאפ777.xlsx', 'storage/app/docs/attachments/1-1659537805-4-1659532846-מילוי מספרים לשליחת הודעת שידור בווצאפ777.xlsx', '', '', '2022-08-04 08:43:00', NULL, 1, '1', 1, '2022-08-04 08:43:26', NULL),
	(77, 'kdjfkjdf', '915', '0params.xlsx', 'storage/app/docs/attachments/1-1659537879-0params.xlsx', '', '', '2022-08-04 08:43:00', NULL, 1, '1', 1, '2022-08-04 08:44:39', NULL),
	(78, 'dd', '950', '0params - less_number.xlsx', 'storage/app/docs/attachments/7-1659589649-0params - less_number.xlsx', '', '', '2022-08-04 13:00:00', NULL, 1, '5', 7, '2022-08-04 23:07:29', NULL),
	(79, 'kdkfkddf', '915', '0params - less_number.xlsx', 'storage/app/docs/attachments/1-1659590740-0params - less_number.xlsx', '', '', '2022-08-04 23:24:00', NULL, 2, '1', 1, '2022-08-04 23:25:40', NULL),
	(80, 'kdkjdkkddfdf', '1245', '0params - less_number.xlsx', 'storage/app/docs/attachments/1-1659596133-0params - less_number.xlsx', '', '', '2022-08-05 00:55:00', NULL, 1, '1', 1, '2022-08-05 00:55:33', NULL),
	(81, 'kdkjdkkdco', '1245', '0params (4).xlsx', 'storage/app/docs/attachments/1-1659684803-0params (4).xlsx', '', '', '2022-08-06 01:11:00', NULL, 1, '1', 1, '2022-08-06 01:33:23', NULL),
	(82, 'sheep', '1245', '0params (4).xlsx', 'storage/app/docs/attachments/1-1659685068-0params (4).xlsx', '', '', '2022-08-06 01:37:00', NULL, 1, '1', 1, '2022-08-06 01:37:48', NULL),
	(83, 'kdkjdkkddfgf', '1280', '0params - less_number.xlsx', 'storage/app/docs/attachments/1-1660714531-0params - less_number.xlsx', '', '', '2022-08-17 23:35:00', NULL, 1, '1', 1, '2022-08-17 23:35:31', NULL),
	(84, 'kdkjdkkddfgf', '1280', '0params - less_number.xlsx', 'storage/app/docs/attachments/1-1660714532-0params - less_number.xlsx', '', '', '2022-08-17 23:35:00', NULL, 1, '1', 1, '2022-08-17 23:35:32', NULL),
	(85, 'kdkjdkkddfadsf', '1280', '0params - less_number.xlsx', 'storage/app/docs/attachments/1-1660714609-0params - less_number.xlsx', '', '', '2022-08-17 23:36:00', NULL, 1, '1', 1, '2022-08-17 23:36:49', NULL),
	(86, 'kdkjdkkddfadsf', '1281', '0params.xlsx', 'storage/app/docs/attachments/1-1660714627-0params.xlsx', '', '', '2022-08-17 23:36:00', NULL, 1, '1', 1, '2022-08-17 23:37:07', NULL),
	(87, 'kdkjdkkddfadsf', '1284', '6params.xlsx', 'storage/app/docs/attachments/1-1660714648-6params.xlsx', '', '', '2022-08-17 23:37:00', NULL, 1, '1', 1, '2022-08-17 23:37:28', NULL);

-- Dumping structure for table chatbox_db.broadcast_log
CREATE TABLE IF NOT EXISTS `broadcast_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `broadcast_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template_metaid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `to_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `no_of_components` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `json_body` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `response_code` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `response` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=351 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table chatbox_db.broadcast_log: ~95 rows (approximately)
INSERT INTO `broadcast_log` (`id`, `account_id`, `broadcast_id`, `template_metaid`, `template_id`, `event`, `file`, `to_number`, `no_of_components`, `json_body`, `response_code`, `response`, `user_id`, `created_at`, `updated_at`) VALUES
	(20, '1', NULL, '544810010471224', '', 'After call', '/app/docs/attachments/1658552845-3params.xlsx', '923081834220', '3', '10015', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923081834220","wa_id":"923081834220"}],"messages":[{"id":"wamid.HBgMOTIzMDgxODM0MjIwFQIAERgSNjFCQzA3QzlDQTk5REMyNjcxAA=="}]}', '1', '2022-07-30 03:31:52', NULL),
	(21, '1', NULL, '544810010471224', '', 'After call', '/app/docs/attachments/1658552845-3params.xlsx', '923458095076', '3', '10015', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSRjYyNERBQzVERTI4ODBDREEwAA=="}]}', '1', '2022-07-30 03:31:53', NULL),
	(22, '1', NULL, '544810010471224', '', 'After call', '/app/docs/attachments/1658552845-3params.xlsx', '923458095076', '3', '10015', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSMzE0Mjc1MUMwRkNBNkJGNkZBAA=="}]}', '1', '2022-07-30 03:31:54', NULL),
	(23, '1', NULL, '544810010471224', '', 'After call', '/app/docs/attachments/1658552845-3params.xlsx', '923081834220', '3', '10015', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923081834220","wa_id":"923081834220"}],"messages":[{"id":"wamid.HBgMOTIzMDgxODM0MjIwFQIAERgSOUEyRTZFMzUxQjVEREMzQzcyAA=="}]}', '1', '2022-07-30 03:31:55', NULL),
	(24, '1', NULL, '544810010471224', '', 'After call', '/app/docs/attachments/1658552845-3params.xlsx', '923081834220', '3', '{"type" : "text", "text" : "Faris"},{"type" : "text", "text" : "200"},{"type" : "text", "text": "2022-08-13 2:30PM"}', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923081834220","wa_id":"923081834220"}],"messages":[{"id":"wamid.HBgMOTIzMDgxODM0MjIwFQIAERgSRjRGNDYwMTk0NkI0QTJENUFFAA=="}]}', '1', '2022-07-30 03:58:15', NULL),
	(25, '1', NULL, '544810010471224', '', 'After call', '/app/docs/attachments/1658552845-3params.xlsx', '923458095076', '3', '{"type" : "text", "text" : "Adam"},{"type" : "text", "text" : "200"},{"type" : "text", "text": "2022-08-13 2:30PM"}', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSODI4RDdEQzY0NUQ0RDBCNDkzAA=="}]}', '1', '2022-07-30 03:58:16', NULL),
	(26, '1', NULL, '544810010471224', '', 'After call', '/app/docs/attachments/1658552845-3params.xlsx', '923458095076', '3', '{"type" : "text", "text" : "Jessica"},{"type" : "text", "text" : "200"},{"type" : "text", "text": "2022-08-13 2:30PM"}', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSMUI4ODFDRjg3NEMzRjdDNjAxAA=="}]}', '1', '2022-07-30 03:58:16', NULL),
	(27, '1', NULL, '544810010471224', '', 'After call', '/app/docs/attachments/1658552845-3params.xlsx', '923081834220', '3', '{"type" : "text", "text" : "Tai Yo"},{"type" : "text", "text" : "252"},{"type" : "text", "text": "2022-08-13 2:30PM"}', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923081834220","wa_id":"923081834220"}],"messages":[{"id":"wamid.HBgMOTIzMDgxODM0MjIwFQIAERgSRDlBMTlBOTkxM0FCMDIwRTQyAA=="}]}', '1', '2022-07-30 03:58:17', NULL),
	(28, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659085579-3params.xlsx', '923013350898', '3', '{"type" : "text", "text" : "Faris"},{"type" : "text", "text" : "200"},{"type" : "text", "text": "2022-08-13 2:30PM"}', '400', '{"error":{"message":"(#132000) Number of parameters does not match the expected number of params","type":"OAuthException","code":132000,"error_data":{"messaging_product":"whatsapp","details":"body: number of localizable_params (3) does not match the expected number of params (0)"},"error_subcode":2494073,"fbtrace_id":"AAkS4sDYLKI5D05ff53Zr_2"}}', '1', '2022-07-30 04:06:20', NULL),
	(29, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659085579-3params.xlsx', '923458095076', '3', '{"type" : "text", "text" : "Adam"},{"type" : "text", "text" : "200"},{"type" : "text", "text": "2022-08-13 2:30PM"}', '400', '{"error":{"message":"(#132000) Number of parameters does not match the expected number of params","type":"OAuthException","code":132000,"error_data":{"messaging_product":"whatsapp","details":"body: number of localizable_params (3) does not match the expected number of params (0)"},"error_subcode":2494073,"fbtrace_id":"A6PpOIY53AT76tCbYUWpVKO"}}', '1', '2022-07-30 04:06:20', NULL),
	(30, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659085579-3params.xlsx', '923458095076', '3', '{"type" : "text", "text" : "Jessica"},{"type" : "text", "text" : "200"},{"type" : "text", "text": "2022-08-13 2:30PM"}', '400', '{"error":{"message":"(#132000) Number of parameters does not match the expected number of params","type":"OAuthException","code":132000,"error_data":{"messaging_product":"whatsapp","details":"body: number of localizable_params (3) does not match the expected number of params (0)"},"error_subcode":2494073,"fbtrace_id":"Aab6Wwsyja2980iqN7Ch0N3"}}', '1', '2022-07-30 04:06:21', NULL),
	(31, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659085579-3params.xlsx', '923458095076', '3', '{"type" : "text", "text" : ""},{"type" : "text", "text" : ""},{"type" : "text", "text": ""}', '400', '{"error":{"message":"(#131008) Required parameter is missing","type":"OAuthException","code":131008,"error_data":{"messaging_product":"whatsapp","details":"Parameter of type text is missing text value"},"error_subcode":2494073,"fbtrace_id":"Aek0H3mHwgXvLWw3NOv3a0X"}}', '1', '2022-07-30 04:06:22', NULL),
	(32, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659085579-3params.xlsx', '923081834220', '3', '{"type" : "text", "text" : ""},{"type" : "text", "text" : ""},{"type" : "text", "text": ""}', '400', '{"error":{"message":"(#131008) Required parameter is missing","type":"OAuthException","code":131008,"error_data":{"messaging_product":"whatsapp","details":"Parameter of type text is missing text value"},"error_subcode":2494073,"fbtrace_id":"A8fti0Rh2NxhrKcBQfwAeeE"}}', '1', '2022-07-30 04:06:23', NULL),
	(33, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659085579-3params.xlsx', '923081834220', '3', '{"type" : "text", "text" : ""},{"type" : "text", "text" : ""},{"type" : "text", "text": ""}', '400', '{"error":{"message":"(#131008) Required parameter is missing","type":"OAuthException","code":131008,"error_data":{"messaging_product":"whatsapp","details":"Parameter of type text is missing text value"},"error_subcode":2494073,"fbtrace_id":"ANF0VrS4pPZ-q3YLZcGSqot"}}', '1', '2022-07-30 04:06:23', NULL),
	(34, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659085579-3params.xlsx', '923081834220', '3', '{"type" : "text", "text" : ""},{"type" : "text", "text" : ""},{"type" : "text", "text": ""}', '400', '{"error":{"message":"(#131008) Required parameter is missing","type":"OAuthException","code":131008,"error_data":{"messaging_product":"whatsapp","details":"Parameter of type text is missing text value"},"error_subcode":2494073,"fbtrace_id":"ATP0_8w_ZhGiwdk8spUivhr"}}', '1', '2022-07-30 04:06:24', NULL),
	(37, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659089951-0params.xlsx', '923458095076', '0', '{\n            "messaging_product": "whatsapp",\n            "to": 923458095076,\n            "type": "template",\n            "template": {\n                "name": "hello_world",\n                "language": {\n                    "code":"en_US" \n                }\n            }\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSOEU3QUU2RjBGNjE3Rjg0MENDAA=="}]}', '1', '2022-07-30 05:19:12', NULL),
	(38, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659089951-0params.xlsx', '923458095076', '0', '{\n            "messaging_product": "whatsapp",\n            "to": 923458095076,\n            "type": "template",\n            "template": {\n                "name": "hello_world",\n                "language": {\n                    "code":"en_US" \n                }\n            }\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSMTY3NzI5QzVGNTU1QTJEQTFFAA=="}]}', '1', '2022-07-30 05:19:13', NULL),
	(39, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659089951-0params.xlsx', '923081834220', '0', '{\n            "messaging_product": "whatsapp",\n            "to": 923081834220,\n            "type": "template",\n            "template": {\n                "name": "hello_world",\n                "language": {\n                    "code":"en_US" \n                }\n            }\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923081834220","wa_id":"923081834220"}],"messages":[{"id":"wamid.HBgMOTIzMDgxODM0MjIwFQIAERgSQTk1MjAyNUVDRUUxOEMxNTM2AA=="}]}', '1', '2022-07-30 05:19:13', NULL),
	(40, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659089951-0params.xlsx', '923081834220', '0', '{\n            "messaging_product": "whatsapp",\n            "to": 923081834220,\n            "type": "template",\n            "template": {\n                "name": "hello_world",\n                "language": {\n                    "code":"en_US" \n                }\n            }\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923081834220","wa_id":"923081834220"}],"messages":[{"id":"wamid.HBgMOTIzMDgxODM0MjIwFQIAERgSQjE5RjNFNTFERDEyOEVCRTgzAA=="}]}', '1', '2022-07-30 05:19:14', NULL),
	(41, '1', NULL, '1070452423644845', '', 'After call', '/app/docs/attachments/1-1659090592-1params.xlsx', '923458095076', '1', '{"type" : "text", "text" : "Faris"}', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSNTAzQkZGRjVFODhDREIzRUE3AA=="}]}', '1', '2022-07-30 05:29:54', NULL),
	(42, '1', NULL, '1070452423644845', '', 'After call', '/app/docs/attachments/1-1659090592-1params.xlsx', '923458095076', '1', '{"type" : "text", "text" : "Adam"}', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSRjYzNEEyQzE0OTYyNUQ2REVDAA=="}]}', '1', '2022-07-30 05:29:55', NULL),
	(43, '1', NULL, '1070452423644845', '', 'After call', '/app/docs/attachments/1-1659090592-1params.xlsx', '923458095076', '1', '{"type" : "text", "text" : "Jessica"}', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSRDFFRjRDREMyRjRGODI5REY5AA=="}]}', '1', '2022-07-30 05:29:55', NULL),
	(44, '1', NULL, '1070452423644845', '', 'After call', '/app/docs/attachments/1-1659090592-1params.xlsx', '923458095076', '1', '{"type" : "text", "text" : ""}', '400', '{"error":{"message":"(#131008) Required parameter is missing","type":"OAuthException","code":131008,"error_data":{"messaging_product":"whatsapp","details":"Parameter of type text is missing text value"},"error_subcode":2494073,"fbtrace_id":"Aiys0OAy_6SDbPUuD8s_57Q"}}', '1', '2022-07-30 05:29:56', NULL),
	(45, '1', NULL, '1070452423644845', '', 'After call', '/app/docs/attachments/1-1659090592-1params.xlsx', '923081834220', '1', '{"type" : "text", "text" : ""}', '400', '{"error":{"message":"(#131008) Required parameter is missing","type":"OAuthException","code":131008,"error_data":{"messaging_product":"whatsapp","details":"Parameter of type text is missing text value"},"error_subcode":2494073,"fbtrace_id":"Az_gWjFqK055fcT56F4LHaZ"}}', '1', '2022-07-30 05:29:59', NULL),
	(46, '1', NULL, '1070452423644845', '', 'After call', '/app/docs/attachments/1-1659090592-1params.xlsx', '923081834220', '1', '{"type" : "text", "text" : ""}', '400', '{"error":{"message":"(#131008) Required parameter is missing","type":"OAuthException","code":131008,"error_data":{"messaging_product":"whatsapp","details":"Parameter of type text is missing text value"},"error_subcode":2494073,"fbtrace_id":"AvTlteMl_mRaaqBY2Ydbe99"}}', '1', '2022-07-30 05:29:59', NULL),
	(47, '1', NULL, '1070452423644845', '', 'After call', '/app/docs/attachments/1-1659090592-1params.xlsx', '923081834220', '1', '{"type" : "text", "text" : ""}', '400', '{"error":{"message":"(#131008) Required parameter is missing","type":"OAuthException","code":131008,"error_data":{"messaging_product":"whatsapp","details":"Parameter of type text is missing text value"},"error_subcode":2494073,"fbtrace_id":"ABJZ9jVx-RPBSlBew_SxxhH"}}', '1', '2022-07-30 05:30:00', NULL),
	(48, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659108060-0params.xlsx', '923458095076', '0', '{\n            "messaging_product": "whatsapp",\n            "to": 923458095076,\n            "type": "template",\n            "template": {\n                "name": "hello_world",\n                "language": {\n                    "code":"en_US" \n                }\n            }\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSNUIwMDcyRkU5RDA1NDg4OTFEAA=="}]}', '1', '2022-07-30 10:21:04', NULL),
	(49, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659108060-0params.xlsx', '923458095076', '0', '{\n            "messaging_product": "whatsapp",\n            "to": 923458095076,\n            "type": "template",\n            "template": {\n                "name": "hello_world",\n                "language": {\n                    "code":"en_US" \n                }\n            }\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSRENCQUFGQjdDQjlGQkZFMjFFAA=="}]}', '1', '2022-07-30 10:21:05', NULL),
	(50, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659108060-0params.xlsx', '923081834220', '0', '{\n            "messaging_product": "whatsapp",\n            "to": 923081834220,\n            "type": "template",\n            "template": {\n                "name": "hello_world",\n                "language": {\n                    "code":"en_US" \n                }\n            }\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923081834220","wa_id":"923081834220"}],"messages":[{"id":"wamid.HBgMOTIzMDgxODM0MjIwFQIAERgSRThDRDlGRTg4NjE1OEJGNDJGAA=="}]}', '1', '2022-07-30 10:21:06', NULL),
	(51, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659108060-0params.xlsx', '27849739047', '0', '{\n            "messaging_product": "whatsapp",\n            "to": 27849739047,\n            "type": "template",\n            "template": {\n                "name": "hello_world",\n                "language": {\n                    "code":"en_US" \n                }\n            }\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"27849739047","wa_id":"27849739047"}],"messages":[{"id":"wamid.HBgLMjc4NDk3MzkwNDcVAgARGBIyODEzNzBGMDgzQzYyRUY0QzUA"}]}', '1', '2022-07-30 10:21:07', NULL),
	(52, '4', NULL, '1972806943110532', '', 'After call', '/app/docs/attachments/4-1659250506-0params.xlsx', '923458095076', '0', '{\n            "messaging_product": "whatsapp",\n            "to": 923458095076,\n            "type": "template",\n            "template": {\n                "name": "test4",\n                "language": {\n                    "code":"he" \n                }\n            }\n        }', '404', '{"error":{"message":"(#132001) Template name does not exist in the translation","type":"OAuthException","code":132001,"error_data":{"messaging_product":"whatsapp","details":"template name (test4) does not exist in he"},"error_subcode":2494073,"fbtrace_id":"AXoAmsFuvEWdlIi8t4ytPve"}}', '3', '2022-08-01 01:55:10', NULL),
	(53, '4', NULL, '1972806943110532', '', 'After call', '/app/docs/attachments/4-1659250506-0params.xlsx', '923458095076', '0', '{\n            "messaging_product": "whatsapp",\n            "to": 923458095076,\n            "type": "template",\n            "template": {\n                "name": "test4",\n                "language": {\n                    "code":"he" \n                }\n            }\n        }', '404', '{"error":{"message":"(#132001) Template name does not exist in the translation","type":"OAuthException","code":132001,"error_data":{"messaging_product":"whatsapp","details":"template name (test4) does not exist in he"},"error_subcode":2494073,"fbtrace_id":"AxlV-PMRU9xrBQKucrJOH-4"}}', '3', '2022-08-01 01:55:12', NULL),
	(54, '4', NULL, '1972806943110532', '', 'After call', '/app/docs/attachments/4-1659250506-0params.xlsx', '923081834220', '0', '{\n            "messaging_product": "whatsapp",\n            "to": 923081834220,\n            "type": "template",\n            "template": {\n                "name": "test4",\n                "language": {\n                    "code":"he" \n                }\n            }\n        }', '404', '{"error":{"message":"(#132001) Template name does not exist in the translation","type":"OAuthException","code":132001,"error_data":{"messaging_product":"whatsapp","details":"template name (test4) does not exist in he"},"error_subcode":2494073,"fbtrace_id":"A4Nd4318wowxG1-Bt0OTuVn"}}', '3', '2022-08-01 01:55:13', NULL),
	(55, '6', NULL, '583333879851353', '', 'After call', '/app/docs/attachments/6-1659252634-0params.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '400', '{"error":{"message":"Unsupported post request. Object with ID \'100238906117303\' does not exist, cannot be loaded due to missing permissions, or does not support this operation. Please read the Graph API documentation at https:\\/\\/developers.facebook.com\\/docs\\/graph-api","type":"GraphMethodException","code":100,"error_subcode":33,"fbtrace_id":"AFU4-PGFwYm5AWn0jwQZpY5"}}', '4', '2022-08-01 02:30:36', NULL),
	(56, '6', NULL, '583333879851353', '', 'After call', '/app/docs/attachments/6-1659252634-0params.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '400', '{"error":{"message":"Unsupported post request. Object with ID \'100238906117303\' does not exist, cannot be loaded due to missing permissions, or does not support this operation. Please read the Graph API documentation at https:\\/\\/developers.facebook.com\\/docs\\/graph-api","type":"GraphMethodException","code":100,"error_subcode":33,"fbtrace_id":"A0ujZekYZyEkPZ89nqKPuQM"}}', '4', '2022-08-01 02:30:36', NULL),
	(57, '6', NULL, '583333879851353', '', 'After call', '/app/docs/attachments/6-1659252634-0params.xlsx', '923081834220', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923081834220,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '400', '{"error":{"message":"Unsupported post request. Object with ID \'100238906117303\' does not exist, cannot be loaded due to missing permissions, or does not support this operation. Please read the Graph API documentation at https:\\/\\/developers.facebook.com\\/docs\\/graph-api","type":"GraphMethodException","code":100,"error_subcode":33,"fbtrace_id":"Aq082LSXgQfkWuLk2RPGJJO"}}', '4', '2022-08-01 02:30:37', NULL),
	(58, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659252733-0params.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '400', '{"error":{"message":"Unsupported post request. Object with ID \'104777585599403\' does not exist, cannot be loaded due to missing permissions, or does not support this operation. Please read the Graph API documentation at https:\\/\\/developers.facebook.com\\/docs\\/graph-api","type":"GraphMethodException","code":100,"error_subcode":33,"fbtrace_id":"Aeb36RmyA0vTV6JCrft0UmE"}}', '1', '2022-08-01 02:32:15', NULL),
	(59, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659252733-0params.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '400', '{"error":{"message":"Unsupported post request. Object with ID \'104777585599403\' does not exist, cannot be loaded due to missing permissions, or does not support this operation. Please read the Graph API documentation at https:\\/\\/developers.facebook.com\\/docs\\/graph-api","type":"GraphMethodException","code":100,"error_subcode":33,"fbtrace_id":"AFVw6oALvCnY2xtq-0-c_XP"}}', '1', '2022-08-01 02:32:15', NULL),
	(60, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659252733-0params.xlsx', '923081834220', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923081834220,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '400', '{"error":{"message":"Unsupported post request. Object with ID \'104777585599403\' does not exist, cannot be loaded due to missing permissions, or does not support this operation. Please read the Graph API documentation at https:\\/\\/developers.facebook.com\\/docs\\/graph-api","type":"GraphMethodException","code":100,"error_subcode":33,"fbtrace_id":"AUyCSSvFVEt35n-_kxRTzNH"}}', '1', '2022-08-01 02:32:16', NULL),
	(61, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659253265-0params.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '401', '{"error":{"message":"Invalid OAuth access token - Cannot parse access token","type":"OAuthException","code":190,"fbtrace_id":"AZ0YDPegtrsfLLdIyICRZ43"}}', '1', '2022-08-01 02:41:06', NULL),
	(62, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659253265-0params.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '401', '{"error":{"message":"Invalid OAuth access token - Cannot parse access token","type":"OAuthException","code":190,"fbtrace_id":"AeMTTweZ1MsV_WsFCFewqKI"}}', '1', '2022-08-01 02:41:07', NULL),
	(63, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659253265-0params.xlsx', '923081834220', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923081834220,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '401', '{"error":{"message":"Invalid OAuth access token - Cannot parse access token","type":"OAuthException","code":190,"fbtrace_id":"AhpE4Z6VBZh3P_X7eF52Cz2"}}', '1', '2022-08-01 02:41:08', NULL),
	(64, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659253540-0params.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '400', '{"error":{"message":"Unsupported post request. Object with ID \'104777585599403\' does not exist, cannot be loaded due to missing permissions, or does not support this operation. Please read the Graph API documentation at https:\\/\\/developers.facebook.com\\/docs\\/graph-api","type":"GraphMethodException","code":100,"error_subcode":33,"fbtrace_id":"A1_Xl4rTm9qMhGFw37n0nXc"}}', '1', '2022-08-01 02:45:41', NULL),
	(65, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659253540-0params.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '400', '{"error":{"message":"Unsupported post request. Object with ID \'104777585599403\' does not exist, cannot be loaded due to missing permissions, or does not support this operation. Please read the Graph API documentation at https:\\/\\/developers.facebook.com\\/docs\\/graph-api","type":"GraphMethodException","code":100,"error_subcode":33,"fbtrace_id":"Ak1B_DnH65M_VZ_5YZbclNl"}}', '1', '2022-08-01 02:45:42', NULL),
	(66, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659253540-0params.xlsx', '923081834220', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923081834220,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '400', '{"error":{"message":"Unsupported post request. Object with ID \'104777585599403\' does not exist, cannot be loaded due to missing permissions, or does not support this operation. Please read the Graph API documentation at https:\\/\\/developers.facebook.com\\/docs\\/graph-api","type":"GraphMethodException","code":100,"error_subcode":33,"fbtrace_id":"ApUulkWQO741ns39r2y6Oq8"}}', '1', '2022-08-01 02:45:42', NULL),
	(67, '4', NULL, '771066267559187', '', 'After call', '/app/docs/attachments/4-1659253905-0params.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '400', '{"error":{"message":"Unsupported post request. Object with ID \'105637618899609\' does not exist, cannot be loaded due to missing permissions, or does not support this operation. Please read the Graph API documentation at https:\\/\\/developers.facebook.com\\/docs\\/graph-api","type":"GraphMethodException","code":100,"error_subcode":33,"fbtrace_id":"ATktFkIsqb7TfVE_TO_IZhF"}}', '3', '2022-08-01 02:51:46', NULL),
	(68, '4', NULL, '771066267559187', '', 'After call', '/app/docs/attachments/4-1659253905-0params.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '400', '{"error":{"message":"Unsupported post request. Object with ID \'105637618899609\' does not exist, cannot be loaded due to missing permissions, or does not support this operation. Please read the Graph API documentation at https:\\/\\/developers.facebook.com\\/docs\\/graph-api","type":"GraphMethodException","code":100,"error_subcode":33,"fbtrace_id":"AQmLesVZbO-JoBb9g_izTtk"}}', '3', '2022-08-01 02:51:48', NULL),
	(69, '4', NULL, '771066267559187', '', 'After call', '/app/docs/attachments/4-1659253905-0params.xlsx', '923081834220', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923081834220,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '400', '{"error":{"message":"Unsupported post request. Object with ID \'105637618899609\' does not exist, cannot be loaded due to missing permissions, or does not support this operation. Please read the Graph API documentation at https:\\/\\/developers.facebook.com\\/docs\\/graph-api","type":"GraphMethodException","code":100,"error_subcode":33,"fbtrace_id":"AqtuAhNLcbzRBhdlYxj018D"}}', '3', '2022-08-01 02:51:48', NULL),
	(70, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659254040-0params.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSM0Y0MTEyMTc5MDA2MzlBRDA1AA=="}]}', '1', '2022-08-01 02:54:04', NULL),
	(71, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659254040-0params.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSMUFERjFBQjBGQzRBMENEM0U4AA=="}]}', '1', '2022-08-01 02:54:05', NULL),
	(72, '1', NULL, '337058128502552', '', 'After call', '/app/docs/attachments/1-1659254040-0params.xlsx', '923081834220', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923081834220,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923081834220","wa_id":"923081834220"}],"messages":[{"id":"wamid.HBgMOTIzMDgxODM0MjIwFQIAERgSNkVGMTQ5NzhDMTBGQ0ZDMTgyAA=="}]}', '1', '2022-08-01 02:54:06', NULL),
	(73, '4', NULL, '1972806943110532', '', 'After call', '/app/docs/attachments/4-1659254409-0params.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "test4",\r\n                "language": {\r\n                    "code":"he" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSODkzMjA1OTZGRUM4QjFGREFEAA=="}]}', '3', '2022-08-01 03:00:11', NULL),
	(74, '4', NULL, '1972806943110532', '', 'After call', '/app/docs/attachments/4-1659254409-0params.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "test4",\r\n                "language": {\r\n                    "code":"he" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSM0JCNTBDRUZBQjE1ODI5N0NGAA=="}]}', '3', '2022-08-01 03:00:12', NULL),
	(75, '4', NULL, '1972806943110532', '', 'After call', '/app/docs/attachments/4-1659254409-0params.xlsx', '923081834220', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923081834220,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "test4",\r\n                "language": {\r\n                    "code":"he" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923081834220","wa_id":"923081834220"}],"messages":[{"id":"wamid.HBgMOTIzMDgxODM0MjIwFQIAERgSOTI1NjU0RDUxRjI2RkI2Mzc3AA=="}]}', '3', '2022-08-01 03:00:14', NULL),
	(76, '1', '67', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659350646-0params.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSMDhBNDcwNkI1NUUzMjAyMEM0AA=="}]}', '1', '2022-08-02 05:44:11', NULL),
	(77, '1', '67', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659350646-0params.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSODg0OUZDRDk0MTVCRTQ1QUI4AA=="}]}', '1', '2022-08-02 05:44:13', NULL),
	(78, '1', '68', '874402596853785', '', 'After call', '/app/docs/attachments/1-1659451907-1params.xlsx', '923458095076', '1', '{"type" : "text", "text" : "Faris"}', '200', '200', '1', '2022-08-03 09:51:48', NULL),
	(79, '1', '68', '874402596853785', '', 'After call', '/app/docs/attachments/1-1659451907-1params.xlsx', '923458095076', '1', '{"type" : "text", "text" : "Adam"}', '200', '200', '1', '2022-08-03 09:51:48', NULL),
	(80, '1', '68', '874402596853785', '', 'After call', '/app/docs/attachments/1-1659451907-1params.xlsx', '923458095076', '1', '{"type" : "text", "text" : "Jessica"}', '200', '200', '1', '2022-08-03 09:51:48', NULL),
	(81, '1', '69', '874402596853785', '', 'After call', '/app/docs/attachments/1-1659451961-1params.xlsx', '923458095076', '1', '{"type" : "text", "text" : "Faris"}', '404', '{"error":{"message":"(#132001) Template name does not exist in the translation","type":"OAuthException","code":132001,"error_data":{"messaging_product":"whatsapp","details":"template name (order_dispatch) does not exist in en"},"error_subcode":2494073,"fbtrace_id":"AknYLdpbSe5QK0FaGyF8tVV"}}', '1', '2022-08-03 09:52:42', NULL),
	(82, '1', '69', '874402596853785', '', 'After call', '/app/docs/attachments/1-1659451961-1params.xlsx', '923458095076', '1', '{"type" : "text", "text" : "Adam"}', '404', '{"error":{"message":"(#132001) Template name does not exist in the translation","type":"OAuthException","code":132001,"error_data":{"messaging_product":"whatsapp","details":"template name (order_dispatch) does not exist in en"},"error_subcode":2494073,"fbtrace_id":"Awb3AxLNJsGwaclVmuo4_0D"}}', '1', '2022-08-03 09:52:43', NULL),
	(83, '1', '69', '874402596853785', '', 'After call', '/app/docs/attachments/1-1659451961-1params.xlsx', '923458095076', '1', '{"type" : "text", "text" : "Jessica"}', '404', '{"error":{"message":"(#132001) Template name does not exist in the translation","type":"OAuthException","code":132001,"error_data":{"messaging_product":"whatsapp","details":"template name (order_dispatch) does not exist in en"},"error_subcode":2494073,"fbtrace_id":"A8fVcexadfRJLlQ6bCzTR9w"}}', '1', '2022-08-03 09:52:44', NULL),
	(84, '1', '70', '874402596853785', '', 'After call', '/app/docs/attachments/1-1659452560-1params.xlsx', '923458095076', '1', '{"type" : "text", "text" : "Faris"}', '404', '{"error":{"message":"(#132001) Template name does not exist in the translation","type":"OAuthException","code":132001,"error_data":{"messaging_product":"whatsapp","details":"template name (order_dispatch) does not exist in ur"},"error_subcode":2494073,"fbtrace_id":"A_HCSGpm225XV_Phm8PDEL0"}}', '1', '2022-08-03 10:02:41', NULL),
	(85, '1', '70', '874402596853785', '', 'After call', '/app/docs/attachments/1-1659452560-1params.xlsx', '923458095076', '1', '{"type" : "text", "text" : "Adam"}', '404', '{"error":{"message":"(#132001) Template name does not exist in the translation","type":"OAuthException","code":132001,"error_data":{"messaging_product":"whatsapp","details":"template name (order_dispatch) does not exist in ur"},"error_subcode":2494073,"fbtrace_id":"Ajg4Fmh6eVtOeVrwETgsPKo"}}', '1', '2022-08-03 10:02:42', NULL),
	(86, '1', '70', '874402596853785', '', 'After call', '/app/docs/attachments/1-1659452560-1params.xlsx', '923458095076', '1', '{"type" : "text", "text" : "Jessica"}', '404', '{"error":{"message":"(#132001) Template name does not exist in the translation","type":"OAuthException","code":132001,"error_data":{"messaging_product":"whatsapp","details":"template name (order_dispatch) does not exist in ur"},"error_subcode":2494073,"fbtrace_id":"AnMoh6puvSxDBVBT0oj6Bin"}}', '1', '2022-08-03 10:02:43', NULL),
	(87, '1', '71', '973785803297380', '', 'After call', '/app/docs/attachments/1-1659514270-1params.xlsx', '923458095076', '1', '{"type" : "text", "text" : "Faris"}', '200', '200', '1', '2022-08-04 03:11:10', NULL),
	(88, '1', '71', '973785803297380', '', 'After call', '/app/docs/attachments/1-1659514270-1params.xlsx', '923081834220', '1', '{"type" : "text", "text" : "Adam"}', '200', '200', '1', '2022-08-04 03:11:10', NULL),
	(89, '1', '72', '973785803297380', '', 'After call', '/app/docs/attachments/1-1659514372-1params.xlsx', '923458095076', '1', '{"type" : "text", "text" : "Faris"}', '200', '200', '1', '2022-08-04 03:12:52', NULL),
	(90, '1', '72', '973785803297380', '', 'After call', '/app/docs/attachments/1-1659514372-1params.xlsx', '923081834220', '1', '{"type" : "text", "text" : "Adam"}', '200', '200', '1', '2022-08-04 03:12:52', NULL),
	(91, '1', '73', '973785803297380', '', 'After call', '/app/docs/attachments/1-1659514452-1params.xlsx', '923458095076', '1', '{"type" : "text", "text" : "Faris"}', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSRUY5MUJENEJENUE0MTVFNUFEAA=="}]}', '1', '2022-08-04 03:14:13', NULL),
	(92, '1', '73', '973785803297380', '', 'After call', '/app/docs/attachments/1-1659514452-1params.xlsx', '923081834220', '1', '{"type" : "text", "text" : "Adam"}', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923081834220","wa_id":"923081834220"}],"messages":[{"id":"wamid.HBgMOTIzMDgxODM0MjIwFQIAERgSMUIyMzA5Q0M4RDM0MjIwMzM3AA=="}]}', '1', '2022-08-04 03:14:14', NULL),
	(93, '4', '74', '3183682541892016', '', 'After call', '/app/docs/attachments/4-1659522339-0params.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "crypto",\r\n                "language": {\r\n                    "code":"he" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSNDlDMDU2N0Q5RTYzM0E3RjUwAA=="}]}', '3', '2022-08-04 05:25:41', NULL),
	(94, '4', '74', '3183682541892016', '', 'After call', '/app/docs/attachments/4-1659522339-0params.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "crypto",\r\n                "language": {\r\n                    "code":"he" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSNTIxNTNENTFDMUJGMjIxNTk0AA=="}]}', '3', '2022-08-04 05:25:42', NULL),
	(95, '7', '78', '613073193482233', '', 'After call', '/app/docs/attachments/7-1659589649-0params - less_number.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSN0ZBOUMxODUzRDhEMzIzMjhGAA=="}]}', '5', '2022-08-05 00:07:32', NULL),
	(96, '7', '78', '613073193482233', '', 'After call', '/app/docs/attachments/7-1659589649-0params - less_number.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSOTM4RTcxN0QyNTExNTI3MkZBAA=="}]}', '5', '2022-08-05 00:07:34', NULL),
	(97, '1', '79', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659590740-0params - less_number.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSN0UyNTYwQjY5RjcxRjFBNjNGAA=="}]}', '1', '2022-08-04 18:25:41', NULL),
	(98, '1', '79', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659590740-0params - less_number.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSRkJDMDJDMENBRDQ5Qzg4MTZEAA=="}]}', '1', '2022-08-04 18:25:42', NULL),
	(99, '1', '80', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659596133-0params - less_number.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSOUMxQTJFMEI5NkU1MjM0QzE0AA=="}]}', '1', '2022-08-04 19:55:34', NULL),
	(100, '1', '80', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659596133-0params - less_number.xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSNEI5OEY5OTgwNkIyODczNDI2AA=="}]}', '1', '2022-08-04 19:55:34', NULL),
	(101, '1', '81', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659684803-0params (4).xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSQ0QzQ0E3N0RCNjdFNDNFNzg5AA=="}]}', '1', '2022-08-05 20:33:28', NULL),
	(102, '1', '81', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659684803-0params (4).xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSMjZEM0FEMTFFMTg4MjRBQjVFAA=="}]}', '1', '2022-08-05 20:33:29', NULL),
	(103, '1', '81', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659684803-0params (4).xlsx', '5531534773', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 5531534773,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '400', '{"error":{"message":"(#131009) Parameter value is not valid","type":"OAuthException","code":131009,"error_data":{"messaging_product":"whatsapp","details":"Parameter Invalid"},"error_subcode":2494010,"fbtrace_id":"A9WFVCsrjGEQ4UqcnMmGSu-"}}', '1', '2022-08-05 20:33:30', NULL),
	(104, '1', '81', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659684803-0params (4).xlsx', '5530321109', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 5530321109,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '400', '{"error":{"message":"(#131009) Parameter value is not valid","type":"OAuthException","code":131009,"error_data":{"messaging_product":"whatsapp","details":"Parameter Invalid"},"error_subcode":2494010,"fbtrace_id":"Ao07bM3MEwlAEBIr3XSYf06"}}', '1', '2022-08-05 20:33:32', NULL),
	(105, '1', '81', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659684803-0params (4).xlsx', '5528748517', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 5528748517,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '400', '{"error":{"message":"(#131009) Parameter value is not valid","type":"OAuthException","code":131009,"error_data":{"messaging_product":"whatsapp","details":"Parameter Invalid"},"error_subcode":2494010,"fbtrace_id":"AeFsRInepjfrWXX1ATDjgrf"}}', '1', '2022-08-05 20:33:33', NULL),
	(106, '1', '81', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659684803-0params (4).xlsx', '5539607662', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 5539607662,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '400', '{"error":{"message":"(#131009) Parameter value is not valid","type":"OAuthException","code":131009,"error_data":{"messaging_product":"whatsapp","details":"Parameter Invalid"},"error_subcode":2494010,"fbtrace_id":"Ar0QPQgYKxCds2HeNpQTU6r"}}', '1', '2022-08-05 20:33:34', NULL),
	(107, '1', '81', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659684803-0params (4).xlsx', '5613125107', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 5613125107,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '400', '{"error":{"message":"(#131009) Parameter value is not valid","type":"OAuthException","code":131009,"error_data":{"messaging_product":"whatsapp","details":"Parameter Invalid"},"error_subcode":2494010,"fbtrace_id":"A5DBd5QqUt6B_dtoMNALUZ9"}}', '1', '2022-08-05 20:33:35', NULL),
	(108, '1', '81', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659684803-0params (4).xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSQkFEMDM4MjJCRDY2MTFBNDU5AA=="}]}', '1', '2022-08-05 20:33:36', NULL),
	(109, '1', '82', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659685068-0params (4).xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSQ0UxMEY4NzcxNEJGRkRCN0RCAA=="}]}', '1', '2022-08-05 20:37:49', NULL),
	(110, '1', '82', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659685068-0params (4).xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSRDY2NkM2ODdFQzJBRDU4N0NCAA=="}]}', '1', '2022-08-05 20:37:50', NULL),
	(111, '1', '82', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659685068-0params (4).xlsx', '5215531534773', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 5215531534773,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"5215531534773","wa_id":"5215531534773"}],"messages":[{"id":"wamid.HBgNNTIxNTUzMTUzNDc3MxUCABEYEkJCMTE4MDgxOURDQzcyMUE5QgA="}]}', '1', '2022-08-05 20:37:51', NULL),
	(112, '1', '82', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659685068-0params (4).xlsx', '5215530321109', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 5215530321109,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"5215530321109","wa_id":"5215530321109"}],"messages":[{"id":"wamid.HBgNNTIxNTUzMDMyMTEwORUCABEYEkQzMDMxNkUyMjZGRTMyMzdBOAA="}]}', '1', '2022-08-05 20:37:53', NULL),
	(113, '1', '82', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659685068-0params (4).xlsx', '5215528748517', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 5215528748517,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"5215528748517","wa_id":"5215528748517"}],"messages":[{"id":"wamid.HBgNNTIxNTUyODc0ODUxNxUCABEYEkU3NEM5QTY0OTg3QTlEOTVFNAA="}]}', '1', '2022-08-05 20:37:55', NULL),
	(114, '1', '82', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659685068-0params (4).xlsx', '5215539607662', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 5215539607662,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"5215539607662","wa_id":"5215539607662"}],"messages":[{"id":"wamid.HBgNNTIxNTUzOTYwNzY2MhUCABEYEjRENkJDMkMzREYzMTk3MDdGNAA="}]}', '1', '2022-08-05 20:37:56', NULL),
	(115, '1', '82', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659685068-0params (4).xlsx', '5215613125107', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 5215613125107,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"5215613125107","wa_id":"5215613125107"}],"messages":[{"id":"wamid.HBgNNTIxNTYxMzEyNTEwNxUCABEYEjZFMzgyNjFDOTVBQzU4RDdFQwA="}]}', '1', '2022-08-05 20:37:57', NULL),
	(116, '1', '82', '337058128502552', '', 'After call', '/app/docs/attachments/1-1659685068-0params (4).xlsx', '923458095076', '0', '{\r\n            "messaging_product": "whatsapp",\r\n            "to": 923458095076,\r\n            "type": "template",\r\n            "template": {\r\n                "name": "hello_world",\r\n                "language": {\r\n                    "code":"en_US" \r\n                }\r\n            }\r\n        }', '200', '{"messaging_product":"whatsapp","contacts":[{"input":"923458095076","wa_id":"923458095076"}],"messages":[{"id":"wamid.HBgMOTIzNDU4MDk1MDc2FQIAERgSOTgyRjMxRDE4NERDMzVEQjBCAA=="}]}', '1', '2022-08-05 20:37:59', NULL);

-- Dumping structure for table chatbox_db.company
CREATE TABLE IF NOT EXISTS `company` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_name` varchar(255) NOT NULL,
  `orgin_country` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `helpline_no` varchar(255) NOT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- Dumping data for table chatbox_db.company: ~6 rows (approximately)
INSERT INTO `company` (`id`, `company_name`, `orgin_country`, `phone`, `helpline_no`, `status`, `created_at`, `updated_at`) VALUES
	(1, 'iProvider', 'Pakistan', '', '', 1, '2022-07-13 03:26:06', '2022-07-13 03:26:06'),
	(2, 'Softskills International', 'Africa', '27663531543', '', 1, '2022-07-16 00:59:17', NULL),
	(3, 'BMeniv', 'Israel', '050-891-1640', '', 1, '2022-07-16 02:04:52', NULL),
	(4, 'Funsy', 'Pakistan', '03052143021', '', 1, '2022-07-21 11:11:01', NULL),
	(5, 'Sheep', 'Mexico', '447502540737', '', 1, '2022-08-04 23:02:50', NULL),
	(6, 'Amol', 'India', '', '', 1, '2023-03-16 06:11:55', NULL);

-- Dumping structure for table chatbox_db.contacts
CREATE TABLE IF NOT EXISTS `contacts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned DEFAULT NULL,
  `phone_number` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visitor_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_account_id_foreign` (`account_id`),
  CONSTRAINT `contacts_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table chatbox_db.contacts: ~1 rows (approximately)
INSERT INTO `contacts` (`id`, `account_id`, `phone_number`, `visitor_name`, `reference`, `user_id`, `status`, `created_at`, `updated_at`) VALUES
	(55, 10, '923081834220', NULL, '1', NULL, NULL, '2023-03-04 01:17:28', NULL);

-- Dumping structure for table chatbox_db.failed_jobs
CREATE TABLE IF NOT EXISTS `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table chatbox_db.failed_jobs: ~0 rows (approximately)

-- Dumping structure for table chatbox_db.migrations
CREATE TABLE IF NOT EXISTS `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8;

-- Dumping data for table chatbox_db.migrations: ~43 rows (approximately)
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(2, '2019_08_19_000000_create_failed_jobs_table', 1),
	(4, '2020_07_08_141130_create_admins_table', 2),
	(6, '2020_07_08_145603_create_permission_tables', 3),
	(7, '2014_10_12_100000_create_password_resets_table', 4),
	(8, '2019_02_02_112609_create_settings_table', 4),
	(9, '2014_10_12_000000_create_users_table', 5),
	(10, '2016_06_01_000001_create_oauth_auth_codes_table', 6),
	(11, '2016_06_01_000002_create_oauth_access_tokens_table', 6),
	(12, '2016_06_01_000003_create_oauth_refresh_tokens_table', 6),
	(13, '2016_06_01_000004_create_oauth_clients_table', 6),
	(14, '2016_06_01_000005_create_oauth_personal_access_clients_table', 6),
	(16, '2020_07_12_220312_create_blogs_table', 7),
	(17, '2022_07_02_132403_create_broadcaste_table', 8),
	(18, '2022_07_03_070329_update_users_table_waba_cred', 8),
	(19, '2022_07_05_101933_update_users_api_url', 8),
	(20, '2022_07_05_134947_create_templates', 8),
	(22, '2022_07_06_000448_upadte_templates_header_info', 9),
	(23, '2022_07_06_160248_update_templates_user_id', 10),
	(24, '2022_07_12_150015_create_company_table', 11),
	(25, '2022_07_12_152021_update_user_table_company_id', 12),
	(26, '2022_07_13_100130_create_accounts_table', 13),
	(27, '2022_07_13_100404_update_template_account_id', 13),
	(28, '2022_07_13_101048_update_account_company_id', 14),
	(29, '2022_07_13_201956_update_account__api__u_r_l', 15),
	(37, '2022_07_29_105335_create_broadcast_log', 16),
	(38, '2022_07_31_135525_upadte_accounts_waba_id', 17),
	(39, '2022_08_01_163125_update_broadcastlog_broadcast_id', 18),
	(40, '2022_08_03_143826_update_templates_footer_buttons', 19),
	(41, '2022_08_04_094846_update_users_timezone', 20),
	(47, '2022_08_09_051758_create_contacts', 21),
	(48, '2022_08_09_051931_create_bot_visitors', 21),
	(49, '2022_08_09_055651_create_bot_actors', 21),
	(50, '2022_08_09_055840_create_bot_msgs', 21),
	(51, '2022_08_09_065629_create_bot_visitor_history', 22),
	(52, '2022_08_11_173019_create_bot_msgs_options', 23),
	(53, '2022_08_12_114501_create_bot_language', 24),
	(54, '2022_08_29_111922_create_bot_visitors_reasult', 25),
	(56, '2022_09_08_114623_update_bot_msg_is_last', 26),
	(57, '2023_02_01_102741_update_botmsgs_template_name', 27),
	(58, '2023_02_01_141134_create_botmsgs_externalaction', 28),
	(59, '2023_02_01_141642_update_botmsgs_is_externalaction', 28),
	(60, '2023_02_02_070050_update_botmsgs_is_context_check', 29),
	(61, '2023_02_02_094928_create_botmsgs_context_table', 30);

-- Dumping structure for table chatbox_db.model_has_permissions
CREATE TABLE IF NOT EXISTS `model_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table chatbox_db.model_has_permissions: ~0 rows (approximately)

-- Dumping structure for table chatbox_db.model_has_roles
CREATE TABLE IF NOT EXISTS `model_has_roles` (
  `role_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table chatbox_db.model_has_roles: ~1 rows (approximately)
INSERT INTO `model_has_roles` (`role_id`, `model_type`, `model_id`) VALUES
	(1, 'App\\Models\\Admin', 1);

-- Dumping structure for table chatbox_db.oauth_access_tokens
CREATE TABLE IF NOT EXISTS `oauth_access_tokens` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `client_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table chatbox_db.oauth_access_tokens: ~11 rows (approximately)
INSERT INTO `oauth_access_tokens` (`id`, `user_id`, `client_id`, `name`, `scopes`, `revoked`, `created_at`, `updated_at`, `expires_at`) VALUES
	('027ae400a8e608d36a65b1fcc48c85aec9f532a63339286a94fc5e06b1bc8b42e531232518a8118e', 1, 4, 'adminApiToken', '[]', 0, '2020-10-15 03:34:15', '2020-10-15 03:34:15', '2021-10-14 14:34:15'),
	('34cfca8b577333694edb5d4a43e45503ca2478f916462fe0c4d3c64a66dfb59f222dc11b06849cf7', 2, 1, 'userApiToken', '[]', 0, '2020-07-19 06:17:50', '2020-07-19 06:17:50', '2021-07-18 17:17:50'),
	('5e16627d27d2480d5dd7e6f1e89604d72d20cb603d31d7a69eed64778ae484e0ff4aeca25ef0bc39', 1, 6, 'adminApiToken', '[]', 0, '2022-08-08 19:33:07', '2022-08-08 19:33:07', '2023-08-08 06:33:07'),
	('67cba7b98c79510c5fac62493938fa857b1cf00da731c40c852ec4949f04be06e0dd476a84d94f8f', 1, 4, 'adminApiToken', '[]', 0, '2020-09-28 05:20:50', '2020-09-28 05:20:50', '2021-09-27 16:20:50'),
	('a419addf4ae7bea31145205699c7e95182f9c9957068f6e32554187ab3f7980bc5374635df10a69f', 1, 4, 'adminApiToken', '[]', 0, '2020-09-29 01:16:49', '2020-09-29 01:16:49', '2021-09-28 12:16:49'),
	('a63a5ed742a080a9d8cf1379aa60e1ba0b0fbc087ffea1e858144bf92f87931119eedd334ace7ffb', 1, 4, 'adminApiToken', '[]', 0, '2020-10-16 00:20:50', '2020-10-16 00:20:50', '2021-10-15 11:20:50'),
	('ab09563fd805d57dc698103035caa419b87a8872d5058901a99919a6770865ef4d1eb0030b7a0f7c', 1, 1, 'userApiToken', '[]', 0, '2020-07-19 06:13:13', '2020-07-19 06:13:13', '2021-07-18 17:13:13'),
	('bb42f06a00a887377a917efd4b8cc381c39b9a18d9d55ea457976b6deaab1b50a18f8545d407ddab', 1, 4, 'adminApiToken', '[]', 0, '2020-09-28 06:21:14', '2020-09-28 06:21:14', '2021-09-27 17:21:14'),
	('bf5ac23d44047b782adcd1c83b5cedb82a474493e8f7584348e664d1220766bbe5808b1eef556a7c', 1, 6, 'adminApiToken', '[]', 0, '2022-08-08 19:23:16', '2022-08-08 19:23:16', '2023-08-08 06:23:16'),
	('d9f29ed0d6be329356ca4be84dcae7fa56eeb89df4efbf9fcbe1dfdc882d9befe5abdc2dd9373383', 1, 4, 'Admin', '[]', 0, '2020-09-28 06:12:30', '2020-09-28 06:12:30', '2021-09-27 17:12:30'),
	('dcf24d9385de348f6322373538b210a7596b880aa7def6aeec7a63e917cd6b8a003a035c9e9e4947', 1, 4, 'adminApiToken', '[]', 0, '2020-09-28 06:20:34', '2020-09-28 06:20:34', '2021-09-27 17:20:34');

-- Dumping structure for table chatbox_db.oauth_auth_codes
CREATE TABLE IF NOT EXISTS `oauth_auth_codes` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `client_id` bigint(20) unsigned NOT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_auth_codes_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table chatbox_db.oauth_auth_codes: ~0 rows (approximately)

-- Dumping structure for table chatbox_db.oauth_clients
CREATE TABLE IF NOT EXISTS `oauth_clients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `secret` varchar(100) DEFAULT NULL,
  `provider` varchar(255) DEFAULT NULL,
  `redirect` text NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

-- Dumping data for table chatbox_db.oauth_clients: ~7 rows (approximately)
INSERT INTO `oauth_clients` (`id`, `user_id`, `name`, `secret`, `provider`, `redirect`, `personal_access_client`, `password_client`, `revoked`, `created_at`, `updated_at`) VALUES
	(1, NULL, 'Laravel7 Boilerplate Personal Access Client', 'Ue8FQpWBQqhtri31cNsPRvbNewyfiQZV7oiGglm9', '', 'http://localhost', 1, 0, 0, '2020-07-13 10:40:52', '2020-07-13 10:40:52'),
	(2, NULL, 'Laravel7 Boilerplate Password Grant Client', 'YnLJHdBV6qJSQHnAzCD4MAOVTpJ9sSmdnM8T78xY', 'users', 'http://localhost', 0, 1, 0, '2020-07-13 10:40:52', '2020-07-13 10:40:52'),
	(3, NULL, 'Moblie Apps', 'ZlnWXAvjeW1CoeKWb6PXI2GfnvjZ3vxrNoQ045E1', 'users', 'http://localhost', 0, 1, 0, '2020-07-19 01:22:38', '2020-07-19 01:22:38'),
	(4, NULL, 'Laravel 8 Boilerplate Personal Access Client', 'EE4IEqacN39YjXXXV5LWWzN3odRfeB5Wu9DA9Qfb', NULL, 'http://localhost', 1, 0, 0, '2020-09-27 06:58:06', '2020-09-27 06:58:06'),
	(5, NULL, 'Laravel 8 Boilerplate Password Grant Client', 'PHyBfYRldhPzj3UGafU0nuEoh1xiARC9dJi316oe', 'users', 'http://localhost', 0, 1, 0, '2020-09-27 06:58:06', '2020-09-27 06:58:06'),
	(6, NULL, 'Laravel Personal Access Client', 'HGCcyGG2cqe18mtWue6FXQUsMdwxP3IeHjLEXQ3Z', NULL, 'http://localhost', 1, 0, 0, '2022-08-08 19:22:16', '2022-08-08 19:22:16'),
	(7, NULL, 'Laravel Password Grant Client', '32jxqpF6diSXnbondYlrZbN9YEdv2szWJ4pBNL4W', 'users', 'http://localhost', 0, 1, 0, '2022-08-08 19:22:16', '2022-08-08 19:22:16');

-- Dumping structure for table chatbox_db.oauth_personal_access_clients
CREATE TABLE IF NOT EXISTS `oauth_personal_access_clients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- Dumping data for table chatbox_db.oauth_personal_access_clients: ~3 rows (approximately)
INSERT INTO `oauth_personal_access_clients` (`id`, `client_id`, `created_at`, `updated_at`) VALUES
	(1, 1, '2020-07-13 10:40:52', '2020-07-13 10:40:52'),
	(2, 4, '2020-09-27 06:58:06', '2020-09-27 06:58:06'),
	(3, 6, '2022-08-08 19:22:16', '2022-08-08 19:22:16');

-- Dumping structure for table chatbox_db.oauth_refresh_tokens
CREATE TABLE IF NOT EXISTS `oauth_refresh_tokens` (
  `id` varchar(100) NOT NULL,
  `access_token_id` varchar(100) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table chatbox_db.oauth_refresh_tokens: ~0 rows (approximately)

-- Dumping structure for table chatbox_db.password_resets
CREATE TABLE IF NOT EXISTS `password_resets` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table chatbox_db.password_resets: ~0 rows (approximately)

-- Dumping structure for table chatbox_db.permissions
CREATE TABLE IF NOT EXISTS `permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;

-- Dumping data for table chatbox_db.permissions: ~21 rows (approximately)
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(1, 'role-view', 'admin', '2020-07-09 04:27:14', '2020-07-09 04:27:14'),
	(2, 'role-create', 'admin', '2020-07-09 04:27:14', '2020-07-09 04:27:14'),
	(3, 'role-edit', 'admin', '2020-07-09 04:27:14', '2020-07-09 04:27:14'),
	(4, 'role-delete', 'admin', '2020-07-09 04:27:14', '2020-07-09 04:27:14'),
	(5, 'permission-view', 'admin', '2020-07-09 04:27:14', '2020-07-09 04:27:14'),
	(6, 'permission-create', 'admin', '2020-07-09 04:27:14', '2020-07-09 04:27:14'),
	(7, 'permission-edit', 'admin', '2020-07-09 04:27:14', '2020-07-09 04:27:14'),
	(8, 'permission-delete', 'admin', '2020-07-09 04:27:14', '2020-07-09 04:27:14'),
	(9, 'user-view', 'admin', '2020-07-09 04:27:14', '2020-07-09 04:27:14'),
	(10, 'user-create', 'admin', '2020-07-09 04:27:14', '2020-07-09 04:27:14'),
	(11, 'user-edit', 'admin', '2020-07-09 04:27:14', '2020-07-09 04:27:14'),
	(12, 'user-delete', 'admin', '2020-07-09 04:27:14', '2020-07-09 04:27:14'),
	(13, 'blog-view', 'admin', '2020-07-14 08:37:29', '2020-07-14 08:37:29'),
	(14, 'blog-create', 'admin', '2020-07-14 08:37:41', '2020-07-14 08:37:41'),
	(15, 'blog-edit', 'admin', '2020-07-14 08:37:49', '2020-07-14 08:37:49'),
	(16, 'blog-delete', 'admin', '2020-07-14 08:37:59', '2020-07-14 08:37:59'),
	(17, 'operator-create', 'user', '2020-10-15 05:18:41', '2020-10-15 05:18:41'),
	(18, 'range-create', 'user', '2020-10-16 00:22:11', '2020-10-16 00:22:11'),
	(19, 'range-view', 'user', '2020-10-16 00:22:18', '2020-10-16 00:22:18'),
	(20, 'range-edit', 'user', '2020-10-16 00:22:31', '2020-10-16 00:22:31'),
	(21, 'range-delete', 'user', '2020-10-16 00:22:37', '2020-10-16 00:22:37');

-- Dumping structure for table chatbox_db.roles
CREATE TABLE IF NOT EXISTS `roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- Dumping data for table chatbox_db.roles: ~2 rows (approximately)
INSERT INTO `roles` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(1, 'superadmin', 'admin', '2020-07-09 04:27:14', '2020-07-09 04:27:14'),
	(2, 'Operator', 'user', '2020-10-16 00:25:02', '2020-10-16 00:25:02');

-- Dumping structure for table chatbox_db.role_has_permissions
CREATE TABLE IF NOT EXISTS `role_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `role_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table chatbox_db.role_has_permissions: ~4 rows (approximately)
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(18, 2),
	(19, 2),
	(20, 2),
	(21, 2);

-- Dumping structure for table chatbox_db.settings
CREATE TABLE IF NOT EXISTS `settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slogan` varchar(255) DEFAULT NULL,
  `eiin` varchar(255) DEFAULT NULL,
  `pabx` varchar(255) DEFAULT NULL,
  `reg` varchar(255) DEFAULT NULL,
  `stablished` varchar(255) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `contact` varchar(255) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `favicon` varchar(255) DEFAULT 'assets/images/logo/favicon.png',
  `social_facebook` varchar(255) DEFAULT 'https://www.facebook.com/',
  `social_twitter` varchar(255) DEFAULT 'https://www.twitter.com/',
  `social_linkedin` varchar(255) DEFAULT 'https://www.linkedin.com/',
  `social_google` varchar(255) DEFAULT 'https://www.google.com/',
  `social_youtube` varchar(255) DEFAULT 'https://www.youtube.com/',
  `layout` varchar(255) NOT NULL DEFAULT '1',
  `maps` text DEFAULT NULL,
  `running_year` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- Dumping data for table chatbox_db.settings: ~1 rows (approximately)
INSERT INTO `settings` (`id`, `name`, `slogan`, `eiin`, `pabx`, `reg`, `stablished`, `email`, `contact`, `address`, `website`, `logo`, `favicon`, `social_facebook`, `social_twitter`, `social_linkedin`, `social_google`, `social_youtube`, `layout`, `maps`, `running_year`, `created_at`, `updated_at`) VALUES
	(1, 'Laravel Boilerplate', 'Knowledge is Power', '123', '123', '12345', '2013', 'riyadhahmed777@gmail.com', '+8801531117886', 'Chattogram, Bangladesh', 'http://riyadh.com/', 'assets/images/logo/1598681688.png', 'assets/images/logo/1571036986.png', 'https://www.facebook.com/', 'https://www.twitter.com/', 'https://www.linkedin.com/', 'https://www.google.com/', 'https://www.youtube.com/', '0', NULL, '2019-2020', '2020-10-15 04:29:11', '2020-10-15 04:29:11');

-- Dumping structure for table chatbox_db.templates
CREATE TABLE IF NOT EXISTS `templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `template_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template_lang` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template_text` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `hader_format` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hader_text` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body_text` text CHARACTER SET utf8mb4 DEFAULT NULL,
  `footer_text` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `button_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `button_text` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `button_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `created_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `accounts_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `templates_accounts_id_foreign` (`accounts_id`),
  CONSTRAINT `templates_accounts_id_foreign` FOREIGN KEY (`accounts_id`) REFERENCES `accounts` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1315 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table chatbox_db.templates: ~113 rows (approximately)
INSERT INTO `templates` (`id`, `template_id`, `template_name`, `template_lang`, `template_text`, `hader_format`, `hader_text`, `body_text`, `footer_text`, `button_type`, `button_text`, `button_url`, `phone_number`, `status`, `created_id`, `created_at`, `updated_at`, `user_id`, `accounts_id`) VALUES
	(290, '2008810499302649', 'hello_world', 'en_US', '', 'TEXT', 'Hello World', 'Welcome and congratulations!! This message demonstrates your ability to send a message notification from WhatsApp Business Platform’s Cloud API. Thank you for taking the time to test with us.', 'WhatsApp Business API Team', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(291, '714014056495683', 'sample_flight_confirmation', 'en_US', '', 'DOCUMENT', 'DOCUMENT', 'This is your flight confirmation for {{1}}-{{2}} on {{3}}.', 'This message is from an unverified business.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(292, '908196187249124', 'sample_flight_confirmation', 'es', '', 'DOCUMENT', 'DOCUMENT', 'Confirmamos tu vuelo a {{1}}-{{2}} para el {{3}}.', 'Este mensaje proviene de un negocio no verificado.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(293, '1013683956011390', 'sample_flight_confirmation', 'id', '', 'DOCUMENT', 'DOCUMENT', 'Ini merupakan konfirmasi penerbangan Anda untuk {{1}}-{{2}} di {{3}}.', 'Pesan ini berasal dari bisnis yang tidak terverifikasi.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(294, '1233495717465975', 'sample_flight_confirmation', 'pt_BR', '', 'DOCUMENT', 'DOCUMENT', 'Esta é a sua confirmação de voo para {{1}}-{{2}} em {{3}}.', 'Esta mensagem é de uma empresa não verificada.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(295, '359192256373727', 'sample_happy_hour_announcement', 'es', '', 'VIDEO', 'VIDEO', '¡Llegó el happy hour! 🍺😀🍸\nA divertirse y disfrutar. 🎉\nLugar: {{1}}\nHora: {{2}}', 'Este mensaje proviene de un negocio no verificado.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(296, '397649239097639', 'sample_happy_hour_announcement', 'en_US', '', 'VIDEO', 'VIDEO', 'Happy hour is here! 🍺😀🍸\nPlease be merry and enjoy the day. 🎉\nVenue: {{1}}\nTime: {{2}}', 'This message is from an unverified business.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(297, '435087135174817', 'sample_happy_hour_announcement', 'pt_BR', '', 'VIDEO', 'VIDEO', 'O happy hour chegou! 🍺😀🍸\nSeja feliz e aproveite o dia. 🎉\nLocal: {{1}}\nHorário: {{2}}', 'Esta mensagem é de uma empresa não verificada.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(298, '477967597384490', 'sample_happy_hour_announcement', 'id', '', 'VIDEO', 'VIDEO', 'Jam diskon telah tiba! 🍺😀🍸\nBergembiralah dan nikmati hari Anda. 🎉\nTempat: {{1}}\nWaktu: {{2}}', 'Pesan ini berasal dari bisnis yang tidak terverifikasi.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(299, '410456037710372', 'sample_issue_resolution', 'pt_BR', '', '', '', 'Oi, {{1}}. Nós conseguimos resolver o problema que você estava enfrentando?', 'Esta mensagem é de uma empresa não verificada.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(300, '585248819663059', 'sample_issue_resolution', 'id', '', '', '', 'Halo {{1}}, apakah kami bisa mengatasi masalah yang sedang Anda hadapi?', 'Pesan ini berasal dari bisnis yang tidak terverifikasi.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(301, '988692811874108', 'sample_issue_resolution', 'en_US', '', '', '', 'Hi {{1}}, were we able to solve the issue that you were facing?', 'This message is from an unverified business.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(302, '1111151079754511', 'sample_issue_resolution', 'es', '', '', '', 'Hola, {{1}}. ¿Pudiste solucionar el problema que tenías?', 'Este mensaje proviene de un negocio no verificado.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(303, '412620187325209', 'sample_movie_ticket_confirmation', 'id', '', 'IMAGE', 'IMAGE', 'Tiket Anda untuk *{{1}}*\n*Waktu* - {{2}}\n*Tempat* - {{3}}\n*Kursi* - {{4}}', 'Pesan ini berasal dari bisnis yang tidak terverifikasi.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(304, '776046116734999', 'sample_movie_ticket_confirmation', 'pt_BR', '', 'IMAGE', 'IMAGE', 'Seu ingresso para *{{1}}*\n*Horário* - {{2}}\n*Local* - {{3}}\n*Assentos* - {{4}}', 'Esta mensagem é de uma empresa não verificada.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(305, '809803103726689', 'sample_movie_ticket_confirmation', 'en_US', '', 'IMAGE', 'IMAGE', 'Your ticket for *{{1}}*\n*Time* - {{2}}\n*Venue* - {{3}}\n*Seats* - {{4}}', 'This message is from an unverified business.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(306, '2170272673155784', 'sample_movie_ticket_confirmation', 'es', '', 'IMAGE', 'IMAGE', 'Tu entrada para *{{1}}*\n*Hora* - {{2}}\n*Lugar* - {{3}}\n*Asientos* - {{4}}', 'Este mensaje proviene de un negocio no verificado.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(307, '373057271632821', 'sample_purchase_feedback', 'es', '', 'IMAGE', 'IMAGE', '¡Gracias por comprar {{1}}! Valoramos tus comentarios y nos gustaría saber cómo fue tu experiencia.', 'Este mensaje proviene de un negocio no verificado.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(308, '511990477358650', 'sample_purchase_feedback', 'id', '', 'IMAGE', 'IMAGE', 'Terima kasih sudah membeli {{1}}! Kami menghargai masukan Anda dan ingin mempelajari lebih lanjut terkait pengalaman Anda.', 'Pesan ini berasal dari bisnis yang tidak terverifikasi.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(309, '855918228707765', 'sample_purchase_feedback', 'pt_BR', '', 'IMAGE', 'IMAGE', 'Agradecemos a aquisição de {{1}}! Valorizamos seu feedback e gostaríamos de saber mais sobre sua experiência.', 'Esta mensagem é de uma empresa não verificada.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(310, '1454021698383275', 'sample_purchase_feedback', 'en_US', '', 'IMAGE', 'IMAGE', 'Thank you for purchasing {{1}}! We value your feedback and would like to learn more about your experience.', 'This message is from an unverified business.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(311, '577752770398634', 'sample_shipping_confirmation', 'id', '', '', '', 'Paket Anda sudah dikirim. Paket akan sampai dalam {{1}} hari kerja.', 'Pesan ini berasal dari bisnis yang tidak terverifikasi.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(312, '876975360359298', 'sample_shipping_confirmation', 'pt_BR', '', '', '', 'Seu pacote foi enviado. Ele será entregue em {{1}} dias úteis.', 'Esta mensagem é de uma empresa não verificada.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(313, '877946146497569', 'sample_shipping_confirmation', 'en_US', '', '', '', 'Your package has been shipped. It will be delivered in {{1}} business days.', 'This message is from an unverified business.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(314, '1070501907179797', 'sample_shipping_confirmation', 'es', '', '', '', 'ó tu paquete. La entrega se realizará en {{1}} dí.', 'Este mensaje proviene de un negocio no verificado.', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(315, '376486524515008', 'welcome', 'en', '', '', '', 'Hello Students,\n\nWelcome to the Soft International.', 'https://softskillsinternational.co.za/', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(316, '1139399406688797', 'welcomoming_message', 'en', '', '', '', 'Hello,\n\nWelcome to the Soft Skills International.', 'https://softskillsinternational.co.za/', NULL, NULL, NULL, NULL, 1, '2', '2022-07-19 13:21:31', NULL, 2, 5),
	(802, '583333879851353', 'hello_world', 'en_US', '', 'TEXT', 'Hello World', 'Welcome and congratulations!! This message demonstrates your ability to send a message notification from WhatsApp Business Platform’s Cloud API. Thank you for taking the time to test with us.', 'WhatsApp Business API Team', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(803, '542616870890894', 'sample_flight_confirmation', 'es', '', 'DOCUMENT', 'DOCUMENT', 'Confirmamos tu vuelo a {{1}}-{{2}} para el {{3}}.', 'Este mensaje proviene de un negocio no verificado.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(804, '746154886716488', 'sample_flight_confirmation', 'pt_BR', '', 'DOCUMENT', 'DOCUMENT', 'Esta é a sua confirmação de voo para {{1}}-{{2}} em {{3}}.', 'Esta mensagem é de uma empresa não verificada.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(805, '761848574967214', 'sample_flight_confirmation', 'id', '', 'DOCUMENT', 'DOCUMENT', 'Ini merupakan konfirmasi penerbangan Anda untuk {{1}}-{{2}} di {{3}}.', 'Pesan ini berasal dari bisnis yang tidak terverifikasi.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(806, '1259998544743158', 'sample_flight_confirmation', 'en_US', '', 'DOCUMENT', 'DOCUMENT', 'This is your flight confirmation for {{1}}-{{2}} on {{3}}.', 'This message is from an unverified business.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(807, '570580941398288', 'sample_happy_hour_announcement', 'id', '', 'VIDEO', 'VIDEO', 'Jam diskon telah tiba! 🍺😀🍸\nBergembiralah dan nikmati hari Anda. 🎉\nTempat: {{1}}\nWaktu: {{2}}', 'Pesan ini berasal dari bisnis yang tidak terverifikasi.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(808, '1045338022841904', 'sample_happy_hour_announcement', 'es', '', 'VIDEO', 'VIDEO', '¡Llegó el happy hour! 🍺😀🍸\nA divertirse y disfrutar. 🎉\nLugar: {{1}}\nHora: {{2}}', 'Este mensaje proviene de un negocio no verificado.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(809, '3142360439413591', 'sample_happy_hour_announcement', 'pt_BR', '', 'VIDEO', 'VIDEO', 'O happy hour chegou! 🍺😀🍸\nSeja feliz e aproveite o dia. 🎉\nLocal: {{1}}\nHorário: {{2}}', 'Esta mensagem é de uma empresa não verificada.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(810, '7615755428499152', 'sample_happy_hour_announcement', 'en_US', '', 'VIDEO', 'VIDEO', 'Happy hour is here! 🍺😀🍸\nPlease be merry and enjoy the day. 🎉\nVenue: {{1}}\nTime: {{2}}', 'This message is from an unverified business.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(811, '436541531820670', 'sample_issue_resolution', 'pt_BR', '', '', '', 'Oi, {{1}}. Nós conseguimos resolver o problema que você estava enfrentando?', 'Esta mensagem é de uma empresa não verificada.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(812, '470626261555476', 'sample_issue_resolution', 'es', '', '', '', 'Hola, {{1}}. ¿Pudiste solucionar el problema que tenías?', 'Este mensaje proviene de un negocio no verificado.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(813, '1101680640783381', 'sample_issue_resolution', 'id', '', '', '', 'Halo {{1}}, apakah kami bisa mengatasi masalah yang sedang Anda hadapi?', 'Pesan ini berasal dari bisnis yang tidak terverifikasi.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(814, '1178565649607976', 'sample_issue_resolution', 'en_US', '', '', '', 'Hi {{1}}, were we able to solve the issue that you were facing?', 'This message is from an unverified business.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(815, '943675460364164', 'sample_movie_ticket_confirmation', 'id', '', 'IMAGE', 'IMAGE', 'Tiket Anda untuk *{{1}}*\n*Waktu* - {{2}}\n*Tempat* - {{3}}\n*Kursi* - {{4}}', 'Pesan ini berasal dari bisnis yang tidak terverifikasi.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(816, '1089502721988846', 'sample_movie_ticket_confirmation', 'en_US', '', 'IMAGE', 'IMAGE', 'Your ticket for *{{1}}*\n*Time* - {{2}}\n*Venue* - {{3}}\n*Seats* - {{4}}', 'This message is from an unverified business.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(817, '1488933241559431', 'sample_movie_ticket_confirmation', 'pt_BR', '', 'IMAGE', 'IMAGE', 'Seu ingresso para *{{1}}*\n*Horário* - {{2}}\n*Local* - {{3}}\n*Assentos* - {{4}}', 'Esta mensagem é de uma empresa não verificada.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(818, '5232081790243804', 'sample_movie_ticket_confirmation', 'es', '', 'IMAGE', 'IMAGE', 'Tu entrada para *{{1}}*\n*Hora* - {{2}}\n*Lugar* - {{3}}\n*Asientos* - {{4}}', 'Este mensaje proviene de un negocio no verificado.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(819, '529297245551277', 'sample_purchase_feedback', 'pt_BR', '', 'IMAGE', 'IMAGE', 'Agradecemos a aquisição de {{1}}! Valorizamos seu feedback e gostaríamos de saber mais sobre sua experiência.', 'Esta mensagem é de uma empresa não verificada.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(820, '610668240363721', 'sample_purchase_feedback', 'en_US', '', 'IMAGE', 'IMAGE', 'Thank you for purchasing {{1}}! We value your feedback and would like to learn more about your experience.', 'This message is from an unverified business.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(821, '983177642377806', 'sample_purchase_feedback', 'es', '', 'IMAGE', 'IMAGE', '¡Gracias por comprar {{1}}! Valoramos tus comentarios y nos gustaría saber cómo fue tu experiencia.', 'Este mensaje proviene de un negocio no verificado.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(822, '1984534391735220', 'sample_purchase_feedback', 'id', '', 'IMAGE', 'IMAGE', 'Terima kasih sudah membeli {{1}}! Kami menghargai masukan Anda dan ingin mempelajari lebih lanjut terkait pengalaman Anda.', 'Pesan ini berasal dari bisnis yang tidak terverifikasi.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(823, '370394961875929', 'sample_shipping_confirmation', 'pt_BR', '', '', '', 'Seu pacote foi enviado. Ele será entregue em {{1}} dias úteis.', 'Esta mensagem é de uma empresa não verificada.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(824, '459695175628446', 'sample_shipping_confirmation', 'es', '', '', '', 'ó tu paquete. La entrega se realizará en {{1}} dí.', 'Este mensaje proviene de un negocio no verificado.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(825, '564974241836786', 'sample_shipping_confirmation', 'id', '', '', '', 'Paket Anda sudah dikirim. Paket akan sampai dalam {{1}} hari kerja.', 'Pesan ini berasal dari bisnis yang tidak terverifikasi.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(826, '591317559061009', 'sample_shipping_confirmation', 'en_US', '', '', '', 'Your package has been shipped. It will be delivered in {{1}} business days.', 'This message is from an unverified business.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(827, '583715493381732', 'welcom', 'en', '', '', '', 'Welcome to Funsy!', 'This message is from an unverified business.', NULL, NULL, NULL, NULL, 1, '4', '2022-08-01 02:30:17', NULL, 4, 6),
	(950, '613073193482233', 'hello_world', 'en_US', '', '', '', 'Welcome and congratulations!! This message demonstrates your ability to send a message notification from WhatsApp Business Platform’s Cloud API. Thank you for taking the time to test with us.', 'WhatsApp Business API Team', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(951, '472642841311361', 'sample_flight_confirmation', 'es', '', '', '', 'Confirmamos tu vuelo a {{1}}-{{2}} para el {{3}}.', 'Este mensaje proviene de un negocio no verificado.', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(952, '575603800904439', 'sample_flight_confirmation', 'id', '', '', '', 'Ini merupakan konfirmasi penerbangan Anda untuk {{1}}-{{2}} di {{3}}.', 'Pesan ini berasal dari bisnis yang tidak terverifikasi.', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(953, '1232984187459442', 'sample_flight_confirmation', 'pt_BR', '', '', '', 'Esta é a sua confirmação de voo para {{1}}-{{2}} em {{3}}.', 'Esta mensagem é de uma empresa não verificada.', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(954, '5716833381680978', 'sample_flight_confirmation', 'en_US', '', '', '', 'This is your flight confirmation for {{1}}-{{2}} on {{3}}.', 'This message is from an unverified business.', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(955, '356750239997575', 'sample_happy_hour_announcement', 'en_US', '', '', '', 'Happy hour is here! 🍺😀🍸\nPlease be merry and enjoy the day. 🎉\nVenue: {{1}}\nTime: {{2}}', 'This message is from an unverified business.', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(956, '622630542553889', 'sample_happy_hour_announcement', 'id', '', '', '', 'Jam diskon telah tiba! 🍺😀🍸\nBergembiralah dan nikmati hari Anda. 🎉\nTempat: {{1}}\nWaktu: {{2}}', 'Pesan ini berasal dari bisnis yang tidak terverifikasi.', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(957, '784874505889180', 'sample_happy_hour_announcement', 'pt_BR', '', '', '', 'O happy hour chegou! 🍺😀🍸\nSeja feliz e aproveite o dia. 🎉\nLocal: {{1}}\nHorário: {{2}}', 'Esta mensagem é de uma empresa não verificada.', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(958, '2947151852251013', 'sample_happy_hour_announcement', 'es', '', '', '', '¡Llegó el happy hour! 🍺😀🍸\nA divertirse y disfrutar. 🎉\nLugar: {{1}}\nHora: {{2}}', 'Este mensaje proviene de un negocio no verificado.', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(959, '427230786110304', 'sample_issue_resolution', 'id', '', '', '', 'Halo {{1}}, apakah kami bisa mengatasi masalah yang sedang Anda hadapi?', '', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(960, '435896288554220', 'sample_issue_resolution', 'es', '', '', '', 'Hola, {{1}}. ¿Pudiste solucionar el problema que tenías?', '', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(961, '577648153904208', 'sample_issue_resolution', 'en_US', '', '', '', 'Hi {{1}}, were we able to solve the issue that you were facing?', '', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(962, '1485906121840427', 'sample_issue_resolution', 'pt_BR', '', '', '', 'Oi, {{1}}. Nós conseguimos resolver o problema que você estava enfrentando?', '', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(963, '358490703125818', 'sample_movie_ticket_confirmation', 'en_US', '', '', '', 'Your ticket for *{{1}}*\n*Time* - {{2}}\n*Venue* - {{3}}\n*Seats* - {{4}}', 'This message is from an unverified business.', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(964, '1139135473611379', 'sample_movie_ticket_confirmation', 'pt_BR', '', '', '', 'Seu ingresso para *{{1}}*\n*Horário* - {{2}}\n*Local* - {{3}}\n*Assentos* - {{4}}', 'Esta mensagem é de uma empresa não verificada.', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(965, '1802163070117721', 'sample_movie_ticket_confirmation', 'id', '', '', '', 'Tiket Anda untuk *{{1}}*\n*Waktu* - {{2}}\n*Tempat* - {{3}}\n*Kursi* - {{4}}', 'Pesan ini berasal dari bisnis yang tidak terverifikasi.', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(966, '1804292739918994', 'sample_movie_ticket_confirmation', 'es', '', '', '', 'Tu entrada para *{{1}}*\n*Hora* - {{2}}\n*Lugar* - {{3}}\n*Asientos* - {{4}}', 'Este mensaje proviene de un negocio no verificado.', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(967, '409356164507098', 'sample_purchase_feedback', 'es', '', '', '', '¡Gracias por comprar {{1}}! Valoramos tus comentarios y nos gustaría saber cómo fue tu experiencia.', '', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(968, '514770430403060', 'sample_purchase_feedback', 'en_US', '', '', '', 'Thank you for purchasing {{1}}! We value your feedback and would like to learn more about your experience.', '', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(969, '798072998020872', 'sample_purchase_feedback', 'pt_BR', '', '', '', 'Agradecemos a aquisição de {{1}}! Valorizamos seu feedback e gostaríamos de saber mais sobre sua experiência.', '', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(970, '818603829518926', 'sample_purchase_feedback', 'id', '', '', '', 'Terima kasih sudah membeli {{1}}! Kami menghargai masukan Anda dan ingin mempelajari lebih lanjut terkait pengalaman Anda.', '', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(971, '459271366044322', 'sample_shipping_confirmation', 'pt_BR', '', '', '', 'Seu pacote foi enviado. Ele será entregue em {{1}} dias úteis.', 'Esta mensagem é de uma empresa não verificada.', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(972, '589115152834268', 'sample_shipping_confirmation', 'es', '', '', '', 'ó tu paquete. La entrega se realizará en {{1}} dí.', 'Este mensaje proviene de un negocio no verificado.', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(973, '993499857987298', 'sample_shipping_confirmation', 'en_US', '', '', '', 'Your package has been shipped. It will be delivered in {{1}} business days.', 'This message is from an unverified business.', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(974, '994699861206531', 'sample_shipping_confirmation', 'id', '', '', '', 'Paket Anda sudah dikirim. Paket akan sampai dalam {{1}} hari kerja.', 'Pesan ini berasal dari bisnis yang tidak terverifikasi.', NULL, NULL, NULL, NULL, 1, '5', '2022-08-05 00:06:07', NULL, 5, 7),
	(1280, '337058128502552', 'hello_world', 'en_US', '', '', '', 'Welcome and congratulations!! This message demonstrates your ability to send a message notification from WhatsApp Business Platform’s Cloud API. Thank you for taking the time to test with us.', 'WhatsApp Business API Team', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1281, '1049888005651606', 'isp_payment_bill', 'en_GB', '', '', '', 'Welcome to The iProvider all in one Solution.', 'www.iprovider.pk', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1282, '544810010471224', 'isp_payment_update', 'en_US', '', '', '', 'Dear {{1}},\n\nYour payment *{{2}}* has been received successfully, Your remaining amount is *{{3}}*.', 'https://iprovider.pk/', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1283, '552089489828074', 'isp_payment_update', 'en_GB', '', '', '', 'Dear {{1}},\n\nBilling Month is : *{{2}}*.\nInvoice # : *{{3}}*.\n\nYour payment *{{3}}* has been received successfully. Your Remaining Amount is *{{4}}*.\n\nThanks\n\nTeam *{{5}}*\nHelpline *{{6}}*.', 'https://iprovider.pk/', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1284, '986782558706689', 'isp_payment_update', 'ur', '', '', '', 'خوش آمدید {{1}}،\n\nبلنگ کا مہینہ ہے : *{{2}}*۔\n\nآپ کی ادائیگی *{{3}}* کامیابی سے موصول ہو گئی ہے۔\nآپ کی بقیہ رقم *{{4}}* ہے۔\n\nشکریہ\nٹیم *{{5}}*۔\nہیلپ لائن: *{{6}}*۔', 'https://iprovider.pk/', '', '', '', NULL, 0, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1285, '874402596853785', 'order_dispatch', 'en', '', '', '', 'Hello To the iProvider Solutions. Your order has been dispatched.\n\nPHONE : {{1}}.', 'www.iprovider.pk', '', '', '', NULL, 0, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1286, '418084389980922', 'payment_update', 'en_GB', '', '', '', '{{4}}\nYour Payment {{1}} for a total of {{2}} is confirmed. The Remaining Amount is {{3}}.', 'https://iprovider.pk/', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1287, '340040384875079', 'sample_flight_confirmation', 'id', '', '', '', 'Ini merupakan konfirmasi penerbangan Anda untuk {{1}}-{{2}} di {{3}}.', 'Pesan ini berasal dari bisnis yang tidak terverifikasi.', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1288, '531571228650749', 'sample_flight_confirmation', 'pt_BR', '', '', '', 'Esta é a sua confirmação de voo para {{1}}-{{2}} em {{3}}.', 'Esta mensagem é de uma empresa não verificada.', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1289, '600960517771032', 'sample_flight_confirmation', 'en_US', '', '', '', 'This is your flight confirmation for {{1}}-{{2}} on {{3}}.', 'This message is from an unverified business.', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1290, '1080124342583302', 'sample_flight_confirmation', 'es', '', '', '', 'Confirmamos tu vuelo a {{1}}-{{2}} para el {{3}}.', 'Este mensaje proviene de un negocio no verificado.', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1291, '373648951412635', 'sample_happy_hour_announcement', 'pt_BR', '', '', '', 'O happy hour chegou! 🍺😀🍸\nSeja feliz e aproveite o dia. 🎉\nLocal: {{1}}\nHorário: {{2}}', 'Esta mensagem é de uma empresa não verificada.', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1292, '3145854638960440', 'sample_happy_hour_announcement', 'id', '', '', '', 'Jam diskon telah tiba! 🍺😀🍸\nBergembiralah dan nikmati hari Anda. 🎉\nTempat: {{1}}\nWaktu: {{2}}', 'Pesan ini berasal dari bisnis yang tidak terverifikasi.', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1293, '3240664122869273', 'sample_happy_hour_announcement', 'en_US', '', '', '', 'Happy hour is here! 🍺😀🍸\nPlease be merry and enjoy the day. 🎉\nVenue: {{1}}\nTime: {{2}}', 'This message is from an unverified business.', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1294, '7563968013644983', 'sample_happy_hour_announcement', 'es', '', '', '', '¡Llegó el happy hour! 🍺😀🍸\nA divertirse y disfrutar. 🎉\nLugar: {{1}}\nHora: {{2}}', 'Este mensaje proviene de un negocio no verificado.', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1295, '323931253242080', 'sample_issue_resolution', 'id', '', '', '', 'Halo {{1}}, apakah kami bisa mengatasi masalah yang sedang Anda hadapi?', '', 'QUICK_REPLY', '[{"type":"QUICK_REPLY","text":"Ya"},{"type":"QUICK_REPLY","text":"Tidak"}]', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1296, '411967163974601', 'sample_issue_resolution', 'es', '', '', '', 'Hola, {{1}}. ¿Pudiste solucionar el problema que tenías?', '', 'QUICK_REPLY', '[{"type":"QUICK_REPLY","text":"S\\u00ed"},{"type":"QUICK_REPLY","text":"No"}]', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1297, '530407678728521', 'sample_issue_resolution', 'pt_BR', '', '', '', 'Oi, {{1}}. Nós conseguimos resolver o problema que você estava enfrentando?', '', 'QUICK_REPLY', '[{"type":"QUICK_REPLY","text":"Sim"},{"type":"QUICK_REPLY","text":"N\\u00e3o"}]', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1298, '973785803297380', 'sample_issue_resolution', 'en_US', '', '', '', 'Hi {{1}}, were we able to solve the issue that you were facing?', '', 'QUICK_REPLY', '[{"type":"QUICK_REPLY","text":"Yes"},{"type":"QUICK_REPLY","text":"No"}]', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1299, '327921086186972', 'sample_movie_ticket_confirmation', 'id', '', '', '', 'Tiket Anda untuk *{{1}}*\n*Waktu* - {{2}}\n*Tempat* - {{3}}\n*Kursi* - {{4}}', 'Pesan ini berasal dari bisnis yang tidak terverifikasi.', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1300, '356838719699957', 'sample_movie_ticket_confirmation', 'pt_BR', '', '', '', 'Seu ingresso para *{{1}}*\n*Horário* - {{2}}\n*Local* - {{3}}\n*Assentos* - {{4}}', 'Esta mensagem é de uma empresa não verificada.', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1301, '423158449669564', 'sample_movie_ticket_confirmation', 'en_US', '', '', '', 'Your ticket for *{{1}}*\n*Time* - {{2}}\n*Venue* - {{3}}\n*Seats* - {{4}}', 'This message is from an unverified business.', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1302, '552101999745665', 'sample_movie_ticket_confirmation', 'es', '', '', '', 'Tu entrada para *{{1}}*\n*Hora* - {{2}}\n*Lugar* - {{3}}\n*Asientos* - {{4}}', 'Este mensaje proviene de un negocio no verificado.', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1303, '552433536508610', 'sample_purchase_feedback', 'pt_BR', '', '', '', 'Agradecemos a aquisição de {{1}}! Valorizamos seu feedback e gostaríamos de saber mais sobre sua experiência.', '', 'URL', '[{"type":"URL","text":"Participe da pesquisa","url":"https:\\/\\/www.example.com\\/"}]', 'https://www.example.com/', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1304, '563949628412357', 'sample_purchase_feedback', 'es', '', '', '', '¡Gracias por comprar {{1}}! Valoramos tus comentarios y nos gustaría saber cómo fue tu experiencia.', '', 'URL', '[{"type":"URL","text":"Responder encuesta","url":"https:\\/\\/www.example.com\\/"}]', 'https://www.example.com/', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1305, '758707975296654', 'sample_purchase_feedback', 'id', '', '', '', 'Terima kasih sudah membeli {{1}}! Kami menghargai masukan Anda dan ingin mempelajari lebih lanjut terkait pengalaman Anda.', '', 'URL', '[{"type":"URL","text":"Ikuti survei","url":"https:\\/\\/www.example.com\\/"}]', 'https://www.example.com/', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1306, '1442786596143863', 'sample_purchase_feedback', 'en_US', '', '', '', 'Thank you for purchasing {{1}}! We value your feedback and would like to learn more about your experience.', '', 'URL', '[{"type":"URL","text":"Take Survey","url":"https:\\/\\/www.example.com\\/"}]', 'https://www.example.com/', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1307, '414434003891269', 'sample_shipping_confirmation', 'en_US', '', '', '', 'Your package has been shipped. It will be delivered in {{1}} business days.', 'This message is from an unverified business.', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1308, '614032412922308', 'sample_shipping_confirmation', 'id', '', '', '', 'Paket Anda sudah dikirim. Paket akan sampai dalam {{1}} hari kerja.', 'Pesan ini berasal dari bisnis yang tidak terverifikasi.', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1309, '1198287554316122', 'sample_shipping_confirmation', 'pt_BR', '', '', '', 'Seu pacote foi enviado. Ele será entregue em {{1}} dias úteis.', 'Esta mensagem é de uma empresa não verificada.', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1310, '3163308360575461', 'sample_shipping_confirmation', 'es', '', '', '', 'ó tu paquete. La entrega se realizará en {{1}} dí.', 'Este mensaje proviene de un negocio no verificado.', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1311, '1070452423644845', 'webinar_hebrew', 'he', '', '', '', 'צהריים טובים תלמידים יקרים,\nבשעה {{1}} יתקיים וובינר בנושא ״השקעות בשוק ההון״\nאנא אשרו השתתפות בבקשה!\n\nזמינים לשירותכם!', '', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1312, '454810725984019', 'welcome', 'en_US', '', '', '', 'Wellcome to EIKONA.', 'https://www.eikona.cl/', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1313, '713617186609766', 'welcome_brochure', 'en_US', '', '', '', 'Welcome to the iProvider Solutions.', '', 'URL', '[{"type":"URL","text":"View Brochure","url":"https:\\/\\/www.iprovider.pk\\/{{1}}"}]', 'https://www.iprovider.pk/{{1}}', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1),
	(1314, '301828465406986', 'welcome_brochure2', 'en_US', '', '', '', 'Welcome to iProvider Solutions.', '', '', '', '', NULL, 1, '1', '2022-08-05 20:46:37', NULL, 1, 1);

-- Dumping structure for table chatbox_db.users
CREATE TABLE IF NOT EXISTS `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `file_path` varchar(255) DEFAULT 'assets/images/users/default.png',
  `status` tinyint(4) DEFAULT 1,
  `remember_token` varchar(100) DEFAULT NULL,
  `Api_URL` varchar(255) DEFAULT NULL,
  `Phone_Number_ID` varchar(255) DEFAULT NULL,
  `User_Access_Token` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `company_id` int(10) unsigned DEFAULT NULL,
  `timezone` varchar(80) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  KEY `users_company_id_foreign` (`company_id`),
  CONSTRAINT `users_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `company` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- Dumping data for table chatbox_db.users: ~5 rows (approximately)
INSERT INTO `users` (`id`, `name`, `email`, `email_verified_at`, `password`, `file_path`, `status`, `remember_token`, `Api_URL`, `Phone_Number_ID`, `User_Access_Token`, `created_at`, `updated_at`, `company_id`, `timezone`) VALUES
	(1, 'Imran Yousuf', 'userone@admin.com', NULL, '$2y$10$NqE8kc.TK6aDdzZurouYleAWOdz7xs654tc6Lt6tvn08RAVerO2tS', 'assets/images/users/1594563348.png', 1, NULL, 'https://graph.facebook.com/v13.0/', '104777585599403', 'EAAQmhO2aDmMBABFHD7rhD8ZBd9nRYBRzjDTENQcPUSDzvTAYUtGi80ZBJZC1HWaWgPkwIZBumuvCNp3vD7SkGHznt8EsxglJx1VnhDppNhHJshh3AnogZARXTKF52dBBNTXZAxIsbTEzZAXTNwKNZCsHtIzQali5FmZA3pKefKJCt1BHKghO2LjikNMJZC0AMZBZCLKh3Lxjg29DZBQZDZD', '2020-07-13 09:15:48', '2020-07-13 09:58:16', 1, 'Asia/Karachi'),
	(2, ' Pascal Nyasha', 'pascal@softskillsinternational.co.za', '2022-07-18 21:51:10', '$2y$10$NqE8kc.TK6aDdzZurouYleAWOdz7xs654tc6Lt6tvn08RAVerO2tS', 'assets/images/users/default.png', 1, NULL, 'https://graph.facebook.com/v13.0/', '107580375355786', 'EAAUwCZAC5RrMBABMfdGodQ4onXEXmjhMCXOZBCcFnwoAW4V79mxxMhZAqdGQ2hsb5vTktDZBMfh45y2fyM7ZBJGXQOY84qrpwjLdJEk6MQWSJGnZA8ZAKRmSsXQeOsAE93B540DGwzscFjNRQAkLpcTyK4xmgVRULTP4zdcPyI9BEHMemZAutcQp', '2022-07-16 01:05:11', NULL, 2, NULL),
	(3, 'Bmi', 'bmi@admin.com', '2022-07-16 02:03:46', '$2y$10$NqE8kc.TK6aDdzZurouYleAWOdz7xs654tc6Lt6tvn08RAVerO2tS', 'assets/images/users/default.png', 1, NULL, NULL, NULL, NULL, '2022-07-16 02:04:00', NULL, 3, NULL),
	(4, 'Roshan', 'roshan@admin.com', '2022-07-21 11:08:44', '$2y$10$NqE8kc.TK6aDdzZurouYleAWOdz7xs654tc6Lt6tvn08RAVerO2tS', 'assets/images/users/default.png', 1, NULL, NULL, NULL, NULL, '2022-07-21 11:08:57', '2022-07-21 11:08:58', 4, NULL),
	(5, 'Alex', 'aromano@sheep.mx', '2022-08-04 23:03:18', '$2y$10$NqE8kc.TK6aDdzZurouYleAWOdz7xs654tc6Lt6tvn08RAVerO2tS', 'assets/images/users/default.png', 1, NULL, NULL, NULL, NULL, '2022-08-04 23:03:33', '2022-08-04 23:03:41', 5, NULL);

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
