<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBotMsgsOptions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bot_msgs_options', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('msgs_id')->unsigned()->nullable();
            $table->foreign('msgs_id')->references('id')->on('bot_msgs');
            $table->longText('option_text')->nullable();
            $table->string('valid_answer',)->nullable();
            $table->string('option_type',)->nullable();
            $table->tinyInteger('status',)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bot_msgs_options');
    }
}
