<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBotVisitorHistory extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bot_visitors_history', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('visitor_id')->unsigned()->nullable();
            $table->foreign('visitor_id')->references('id')->on('bot_visitors');
            $table->unsignedBigInteger('msg_id')->unsigned()->nullable();
            $table->foreign('msg_id')->references('id')->on('bot_msgs');
            $table->longText('text')->nullable();
            $table->string('wamid',)->nullable();
            $table->string('return_timestamp')->nullable();
            $table->tinyInteger('status',)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bot_visitor_history');
    }
}
