<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBotMsgs extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bot_msgs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('actor_id')->unsigned()->nullable();
            $table->foreign('actor_id')->references('id')->on('bot_actors');
            $table->string('sequence',)->nullable();
            $table->string('language',)->nullable();
            $table->tinyInteger('is_template',)->nullable();
            $table->string('template_id',)->nullable();
            $table->longText('text',)->nullable();
            $table->string('type',)->nullable();
            $table->tinyInteger('status',)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bot_msgs');
    }
}
