<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBroadcastLog extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('broadcast_log', function (Blueprint $table) {
            $table->id();
            $table->string('account_id')->nullable();
            $table->string('template_metaid')->nullable();
            $table->string('template_id')->nullable();
            $table->string('event')->nullable();
            $table->string('file')->nullable();
            $table->string('to_number')->nullable();
            $table->longText('no_of_components')->nullable();
            $table->longText('json_body')->nullable();
            $table->longText('response_code')->nullable();
            $table->longText('response')->nullable();
            $table->string('user_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('broadcast_log');
    }
}
