<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBroadcasteTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('broadcaste', function (Blueprint $table) {
            $table->id();
            $table->string('b_code')->unique();
            $table->string('template_name');
            $table->string('csv_path');
            $table->dateTime('time_to_execuate')->nullable();
            $table->tinyInteger('execuate_status')->nullable();
            $table->tinyInteger('status');
            $table->string('created_id', 100)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('broadcaste');
    }
}
