<?php

namespace App\Models;

use App\Models\Users\AccountsModel;
use App\Models\Users\Botmessageoption;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use App\Models\Users\BroadcastLog;

class WhatsappBotApi extends Model
{
  public $api_url;
  public $token;
  public $phone_number_id;
  function __construct($bot_number)
  {
    // get the cred from accounts table(or selected from the dropdown account)
    $accountData =  AccountsModel::getAccountsonPoneNumber($bot_number);

    $this->api_url = $accountData->api_url;
    $this->token = $accountData->user_access_token;
    $this->phone_number_id = $accountData->phone_number_id;
    $this->waba_id = $accountData->waba_id;
  }
  public  function BotSimpleMessage($visitor_phone, $msg_data)
  {

    $curl = curl_init();
    $URL = $this->api_url . $this->phone_number_id . '/messages';
    curl_setopt_array($curl, array(
      CURLOPT_URL => $URL,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS => '{
            "messaging_product": "whatsapp",
            "recipient_type": "individual",
            "to": ' . $visitor_phone . ',
            "type": "text",
            "text": {
            "preview_url" : false,
            "body" : "' . nl2br($msg_data) . '",
            }
        }',
      CURLOPT_HTTPHEADER => array(
        "Content-Type: application/json",
        "Authorization: Bearer $this->token"
      ),
    ));

    $response = curl_exec($curl);

    $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);
    echo $response;
    return $httpcode;
  }

  public  function BotInteractiveMessage($visitor_phone, $front_msg, $msg_data_options)
  {

    $txt = Botmessageoption::formattingInteractivMessage($msg_data_options);

    $curl = curl_init();
    $URL = $this->api_url . $this->phone_number_id . '/messages';
    curl_setopt_array($curl, array(
      CURLOPT_URL =>  $URL,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',


      CURLOPT_POSTFIELDS => '{
    "messaging_product": "whatsapp",
    "recipient_type": "individual",
    "to": ' . $visitor_phone . ',
    "type": "interactive",
    "interactive": {
		"type" : "list",
		
		"body": {
			"text": "' . $front_msg . '"
		},
		
		"action": {
      "button": "Options",
      "sections":[
        {
          "title": "' . substr($front_msg, 0, 24) . '",
          "rows": [
            ' . $txt . '
          ]
        }
       
      ]
    }
  }
    
}',




      CURLOPT_HTTPHEADER => array(
        "Content-Type: application/json",
        "Authorization: Bearer $this->token"
      ),
    ));

    $response = curl_exec($curl);

    $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);
    echo $response;
    return $httpcode;
  }

  public  function BotButtonMessage($visitor_phone, $msg_data, $button_options = null)
  {
    $txt = Botmessageoption::formattingbuttonMessage($button_options);
    $curl = curl_init();
    $URL = $this->api_url . $this->phone_number_id . '/messages';
    curl_setopt_array($curl, array(
      CURLOPT_URL => $URL,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS => '{
    "messaging_product": "whatsapp",
    "recipient_type": "individual",
    "to": ' . $visitor_phone . ',
    "type": "interactive",
    "interactive":{
		"type": "button",
		 "body": {
		  "text":"' . nl2br(($msg_data)) . '",
		},
	  "action": {
      "buttons": [
        ' . $txt . '
        ] 
      }
    }
  }',
      CURLOPT_HTTPHEADER => array(
        "Content-Type: application/json",
        "Authorization: Bearer $this->token"
      ),
    ));

    $response = curl_exec($curl);
    $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);
    echo $response;
    return $httpcode;
  }

  public  function BotProdutMessage($visitor_phone, $front_msg, $msg_data_options)
  {
    $txt = Botmessageoption::formattingInteractivProductMessage($msg_data_options);

    $curl = curl_init();
    $URL = $this->api_url . $this->phone_number_id . '/messages';
    curl_setopt_array($curl, array(
      CURLOPT_URL => $URL,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',


      CURLOPT_POSTFIELDS => '{
    "messaging_product": "whatsapp",
    "recipient_type": "individual",
    "to": ' . $visitor_phone . ',
    "type": "interactive",
    "interactive": {
		"type" : "list",
		
		"body": {
			"text": "' . $front_msg . '"
		},
		
		"action": {
      "button": "Options",
      "sections":[
        ' . $txt . '
       
      ]
    }
  }
    
}',




      CURLOPT_HTTPHEADER => array(
        "Content-Type: application/json",
        "Authorization: Bearer $this->token"
      ),
    ));

    $response = curl_exec($curl);

    $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);
    echo $response;
    return $httpcode;
  }



  public  function BotTemplateSimple($visitor_phone, $msg_data)
  {
    //return $msg_data->template_name;
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => $this->api_url . $this->phone_number_id . '/messages',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS => '{
      "messaging_product": "whatsapp",
      "recipient_type": "individual",
      "to": ' . $visitor_phone . ',
      "type": "template",
      "template": {
        "name":  "' . $msg_data->template_name . '",
        "language": {
          "code": "en_US"
        },
       
      }
    }',
      CURLOPT_HTTPHEADER => array(
        'Content-Type: application/json',
        "Authorization: Bearer $this->token"
      ),
    ));

    $response = curl_exec($curl);

    $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);
    echo $response;
    return $httpcode;
  }
}
