<?php

namespace App\Models\Users;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Contacts extends Model
{
    protected $table = 'contacts';
    use HasFactory;

    //get Accounts of a particular company
    public static function getContact($phone_number, $accountInfo)
    {
        $data = Contacts::where('phone_number', $phone_number)
            //->where('status', 1)
            ->where('account_id', $accountInfo->id)
            ->get()->first();
        return $data;
    }

    public static function saveContact($account_id, $visitor_phone, $visitor_name)
    {

        $submit_data = array(
            'account_id' => $account_id,
            'phone_number' => $visitor_phone,
            'visitor_name' => $visitor_name,
            'reference' => 1,
            'status' => 1,
            'created_at' => NOW()
        );
        $contact_id = DB::table('contacts')->insertGetId($submit_data);
        return $contact_id;
    }
}
