<?php

namespace App\Models\Users;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Botvisitorhistory extends Model
{
    protected $table = 'bot_visitors_history';
    use HasFactory;



    //get Accounts of a particular company
    public static function saveVisitorHistory($visitor_id, $msg_id, $text, $wamid, $visitor_lang = NULL, $seq)
    {
        // $last_answer =  Contacts::select('bot_visitors_history.msg_id', 'bot_visitors_history.sequence', 'bot_visitors_history.created_at')
        //     ->join('bot_visitors', 'bot_visitors.contact_id', '=', 'contacts.id')
        //     ->join('bot_visitors_history', 'bot_visitors_history.visitor_id', '=', 'bot_visitors.id')
        //     ->where('bot_visitors_history.visitor_id', $visitor_id)
        //     ->where('bot_visitors_history.status', 1)
        //     ->latest()->first();
        $botoption = Botmessageoption::where('valid_answer', $text)->get()->first();
        if (isset($botoption)) {
            $value = $botoption->option_text;
        } else {
            $value = $text;
        }
        //$value = $botoption->option_text;

        $submit_data = array(
            'visitor_id' => $visitor_id,
            'sequence' => $seq,
            'msg_id' => $msg_id,
            'text' => $text,
            'value' => $value,
            'visitor_language' => $visitor_lang,
            // 'visitor_actor' => $visitor_actor,
            'wamid' => $wamid,
            'return_timestamp' => "2",
            'status' => 1,
            'created_at' => NOW()
        );
        $save = DB::table('bot_visitors_history')->insert($submit_data);

        return  $save;
    }


    public static function updateVisitorHistory($vistor_id)
    {

        // DB::table('bot_visitors_history')
        //     ->updateOrInsert(
        //         ['bot_visitors_history.visitor_id' => $vistor_id],
        //         ['status' => 0, 'updated_at' => date("Y-m-d H:i:s")]
        //     );
        DB::table('bot_visitors_history')
            ->where('visitor_id', $vistor_id)
            ->update(['status' => 0]);
    }

    public static function getVisithistory($visitor_id)
    {
        $data = Botvisitorhistory::Select('bot_visitors_history.id', 'bot_visitors_history.msg_id', 'bot_visitors_history.visitor_language', 'bot_visitors_history.visitor_actor', 'bot_visitors_history.visitor_id')
            ->where('bot_visitors_history.status', 1)
            ->where('bot_visitors_history.visitor_id', $visitor_id)
            ->latest('bot_visitors_history.id')
            ->first();

        return $data;
    }
    public static function getVisitSession($visitor_id)
    {
        $data = Botvisitorhistory::Select('bot_visitors_history.id', 'bot_visitors_history.msg_id', 'bot_visitors_history.visitor_language', 'bot_visitors_history.visitor_actor', 'bot_visitors_history.visitor_id')
            ->where('bot_visitors_history.status', 1)
            ->where('bot_visitors_history.visitor_id', $visitor_id)
            ->latest('bot_visitors_history.id')
            ->get();

        return $data;
    }
    public static function getData($actor_id)
    {
        $reasult =  Botvisitorhistory::select('contacts.visitor_name', 'contacts.phone_number', 'bot_visitors_history.id', 'bot_visitors_history.msg_id')
            ->join('bot_visitors', 'bot_visitors.id', '=', 'bot_visitors_history.visitor_id')
            ->join('contacts', 'contacts.id', '=', 'bot_visitors.contact_id')
            ->where('bot_visitors_history.status', '=',  1)
            ->where('bot_visitors_history.visitor_actor', '!=',  $actor_id)
            ->where('bot_visitors_history.visitor_actor', '!=',  3)
            //->where('bot_visitors_history.sequence', '=',  1)
            ->orderBy('bot_visitors_history.created_at', 'desc')
            ->get();
        return $reasult;
    }

    public static function revertBack($msg_id, $visitorID)
    {
        //get the id and set status greater then all of that visitor only
        $botvisitorHistory =  Botvisitorhistory::select('id')->where('msg_id', $msg_id)
            ->where('visitor_id', $visitorID)
            ->get()->first();

        DB::statement("UPDATE bot_visitors_history 
            SET STATUS = 0
            WHERE bot_visitors_history.id > $botvisitorHistory->id
            AND bot_visitors_history.visitor_id = $visitorID");
        DB::statement("UPDATE botmsgs_fomula_values 
            SET STATUS = 0ch
            WHERE botmsgs_fomula_values.fk_visitor_id = $visitorID");
    }
    public static function checkIfGo($vistor_phone_no, $visitorID)
    {
        // $chekcifGo =  Contacts::select('bot_visitors_history.msg_id', 'bot_visitors_history.sequence', 'bot_visitors_history.created_at')
        //     ->join('bot_visitors', 'bot_visitors.contact_id', '=', 'contacts.id')
        //     ->join('bot_visitors_history', 'bot_visitors_history.visitor_id', '=', 'bot_visitors.id')
        //     ->where('contacts.phone_number', $vistor_phone_no)
        //     ->where('bot_visitors_history.status', 1)
        //     ->count('bot_visitors_history.id');

        $SIP_DYNAMIC = BotmsgFormulaValue::where('fk_visitor_id', $visitorID)
            ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
            ->where('botmsgs_formula.name', 'SIP_DYNAMIC')
            ->where('botmsgs_fomula_values.status', 1)->get()->first();
        $ONETIME_SIP_CALCU = BotmsgFormulaValue::where('fk_visitor_id', $visitorID)
            ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
            ->where('botmsgs_formula.name', 'ONETIME_SIP_CALCU')
            ->where('botmsgs_fomula_values.status', 1)->get()->first();
        // if both one time and monthly has some values then give true or stop/return bot
        if (!is_null($ONETIME_SIP_CALCU) && !is_null($SIP_DYNAMIC)) {
            return true;
        } else {
            return false;
        }

        //->latest()->first();
    }
}
