<?php

namespace App\Models\Users;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class BotvisitorReasult extends Model
{
    protected $table = 'bot_visitors_reasult';
    use HasFactory;



    //get Accounts of a particular company
    public static function saveVisitorReasult($visitor_id, $msg_id, $text, $wamid, $visitor_lang = NULL, $visitor_actor = NULL)
    {
        $submit_data = array(
            'visitor_id' => $visitor_id,
            'msg_id' => $msg_id,
            'text' => $text,
            'visitor_language' => $visitor_lang,
            'visitor_actor' => $visitor_actor,
            'wamid' => $wamid,
            'return_timestamp' => "2",
            'status' => 1,
            'created_at' => NOW()
        );
        $save = DB::table('bot_visitors_history')->insert($submit_data);

        return  $save;
    }

    public static function getVisitReasult($visitor_id)
    {
        $data = BotvisitorReasult::Select('bot_visitors_reasult.*')
            ->where('bot_visitors_reasult.status', 1)
            ->where('bot_visitors_reasult.visitor_visit_id', $visitor_id)
            ->first();

        return $data;
    }

    public static function saveVisitorLanguage($visitor_id, $lang)
    {

        DB::table('bot_visitors_reasult')
            ->updateOrInsert(
                ['bot_visitors_reasult.visitor_visit_id' => $visitor_id],
                ['bot_visitors_reasult.visitor_lang' => $lang]

            );
    }
    public static function saveVisitorActor($visitor_id, $lang)
    {

        DB::table('bot_visitors_reasult')
            ->updateOrInsert(
                ['bot_visitors_reasult.visitor_visit_id' => $visitor_id],
                ['bot_visitors_reasult.visitor_actor' => $lang]

            );
    }
}
