<?php

namespace App\Models\Users;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use App\Models\Users\AccountsModel;
use App\Models\WhatsappBotApi;

class BotmsgFormula extends Model
{
    protected $table = 'botmsgs_formula';
    use HasFactory;

    public static function putFormula($text, $botFormula, $visitorID, $currentValue, $botInfo)
    {
        $botSavedNoOfyear = Botvisitorhistory::whereIn('text', array('50.3', '50.4', '50.5', '50.6', '50.7', '50.8', '50.9', '50.10', '59.1', '59.2', '59.3', '59.4', '59.5', '59.6', '59.7', '59.8', '59.9', '59.10'))
            ->where('visitor_id', $visitorID)
            ->where('status', 1)
            ->get()->first();

        $NoOfYear = preg_replace('/[^0-9]/', '', $botSavedNoOfyear->value);
        $noOfMonth = 12 * $NoOfYear;
        if ($NoOfYear >= 5) {
            $interstRate = BotmsgVariable::where('name', 'AGGRESIVE_CATEGORY')
                ->where('fk_bot_info', $botInfo->id)
                ->where('status', 1)
                ->get()->first();
        } else {
            $interstRate = BotmsgVariable::where('name', 'MODERATE_CATEGORY')
                ->where('fk_bot_info', $botInfo->id)
                ->where('status', 1)
                ->get()->first();
        }



        switch ($botFormula->name) {
            case "LUMSUM_CALC":

                // check if bot visitor selected the car option / set the interest rate accordingly
                $botSavedDream = Botvisitorhistory::whereIn('text', array(49.1, 49.2, 49.3, 49.4))
                    ->where('visitor_id', $visitorID)
                    ->where('status', 1)
                    ->get()->first();

                if (isset($botSavedDream) && isset($botSavedNoOfyear) && isset($currentValue)) {

                    // check either dream is car / education or whatever and put he interst rate accordingly
                    $interstRate =  BotmsgVariable::getLumSumInterstRate($botSavedDream->text);

                    $PresentValue = $currentValue;
                    $LumSumValue = $PresentValue * pow(1 + $interstRate, $NoOfYear);
                    // save it for furthre calculation
                    BotmsgFormula::saveFormulaValue(intval($LumSumValue), $botInfo->id,  $visitorID, $botFormula->id);
                    $LumSumValue = BotmsgFormula::moneyFormatIndia(intval($LumSumValue));
                    return ($LumSumValue);
                }

                break;
            case "SIP_CALCU":

                $LumSumCalculatedValue = BotmsgFormulaValue::where('fk_visitor_id', $visitorID)
                    ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
                    ->where('botmsgs_formula.name', 'LUMSUM_CALC')
                    ->where('botmsgs_fomula_values.fk_bot_info_id', $botInfo->id)
                    ->where('botmsgs_fomula_values.status', 1)->get()->first();
                $noOfMonth = 12 * $NoOfYear;
                $abc = $interstRate->value / 12;
                $P = $LumSumCalculatedValue->value / ((pow(1 + $abc, $noOfMonth) - 1) / $abc) * (1 + $abc);
                BotmsgFormula::saveFormulaValue(intval($P), $botInfo->id,  $visitorID, $botFormula->id);
                $P = BotmsgFormula::moneyFormatIndia(intval($P));

                return $P;
                //return number_format(intval($P));
                //return intval($P);

                break;
            case "MONTLY_SAVE":

                $LumSumCalculatedValue = BotmsgFormulaValue::where('fk_visitor_id', $visitorID)
                    ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
                    ->where('botmsgs_formula.name', 'LUMSUM_CALC')
                    ->where('botmsgs_fomula_values.fk_bot_info_id', $botInfo->id)
                    ->where('botmsgs_fomula_values.status', 1)->get()->first();

                $SIP_CALCU = BotmsgFormulaValue::where('fk_visitor_id', $visitorID)
                    ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
                    ->where('botmsgs_formula.name', 'SIP_CALCU')
                    ->where('botmsgs_fomula_values.fk_bot_info_id', $botInfo->id)
                    ->where('botmsgs_fomula_values.status', 1)->get()->first();
                $noOfMonth = 12 * $NoOfYear;
                $abc = $interstRate->value / 12;


                $MONTLY_SAVE = $LumSumCalculatedValue->value - ($noOfMonth * $SIP_CALCU->value);
                BotmsgFormula::saveFormulaValue(intval($MONTLY_SAVE), $botInfo->id,  $visitorID, $botFormula->id);
                $MONTLY_SAVE = BotmsgFormula::moneyFormatIndia(intval($MONTLY_SAVE));

                return $MONTLY_SAVE;


                break;
            case "RISK_CATEGORY":
                if ($NoOfYear >= 5) {
                    BotmsgFormula::saveFormulaValue("Aggressive category", $botInfo->id,  $visitorID, $botFormula->id);
                    return "Aggressive category";
                } else {
                    BotmsgFormula::saveFormulaValue("Moderate category", $botInfo->id,  $visitorID, $botFormula->id);
                    return "Moderate category";
                }
                break;
            case "SIP_DYNAMIC":
                // save first input as MONTHLY_INPUT.
                BotmsgFormula::saveFormulaValue($currentValue, $botInfo->id,  $visitorID, 21);
                $p = $currentValue;
                $n = $noOfMonth;
                $i = $interstRate->value / 12;
                //$M = $p* ( { [1+$i]$n-1}/$i ) * (1 + $i);
                $M = $p * (pow(1 + $i, $noOfMonth) - 1) / $i * (1 + $i);
                BotmsgFormula::saveFormulaValue(intval($M), $botInfo->id,  $visitorID, $botFormula->id);
                $M = BotmsgFormula::moneyFormatIndia(intval($M));

                return $M;

                //break;
            case "SYP_DYNAMIC_SHORTFALL":
                // PV = 571759/(1 + 0.13)^ 5
                $LumSumCalculatedValue = BotmsgFormulaValue::where('fk_visitor_id', $visitorID)
                    ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
                    ->where('botmsgs_formula.name', 'LUMSUM_CALC')
                    ->where('botmsgs_fomula_values.fk_bot_info_id', $botInfo->id)
                    ->where('botmsgs_fomula_values.status', 1)->get()->first();

                $SIPdynamic = BotmsgFormulaValue::where('fk_visitor_id', $visitorID)
                    ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
                    ->where('botmsgs_formula.name', 'SIP_DYNAMIC')
                    ->where('botmsgs_fomula_values.fk_bot_info_id', $botInfo->id)
                    ->where('botmsgs_fomula_values.status', 1)->get()->first();
                $shortFall = $LumSumCalculatedValue->value - $SIPdynamic->value;
                BotmsgFormula::saveFormulaValue(intval($shortFall), $botInfo->id,  $visitorID, $botFormula->id);
                if ($shortFall <= 0) {

                    $text =  preg_replace('{{{SYP_DYNAMIC_SHORTFALL}}}', $shortFall, $text);
                    $text =  preg_replace('{{{COVER_TEXT_1}}}', "Do you want us to call you for execution to make your dream come true?", $text);

                    $accountInfo = AccountsModel::find($botInfo->account_id);
                    $botVisitor  = Botvisitor::find($visitorID);
                    $contactData = Contacts::find($botVisitor->contact_id);
                    //$text_to_be_sent = Botmessage::where('id', 87)->first();
                    $button_options = Botmessageoption::where('msgs_id', 87)->get();
                    $whatsapp_obj = new WhatsappBotApi($accountInfo->phone_number);
                    $resp_code =  $whatsapp_obj->BotButtonMessage($contactData->phone_number, $text, $button_options);
                    $re =  Botvisitorhistory::saveVisitorHistory($visitorID, 87, $currentValue, '', "", '');
                    exit();
                }


                $shortFall = BotmsgFormula::moneyFormatIndia(intval($shortFall));
                return $shortFall;
                //break;
            case "COVER_TEXT_1":
                $SYP_DYNAMIC_SHORTFALL = BotmsgFormulaValue::where('fk_visitor_id', $visitorID)
                    ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
                    ->where('botmsgs_formula.name', 'SYP_DYNAMIC_SHORTFALL')
                    ->where('botmsgs_fomula_values.fk_bot_info_id', $botInfo->id)
                    ->where('botmsgs_fomula_values.status', 1)->get()->first();

                if ($SYP_DYNAMIC_SHORTFALL->value > 0) {
                    BotmsgFormula::saveFormulaValue("Do you want to cover this shortfall?", $botInfo->id,  $visitorID, $botFormula->id);
                    return "Do you want to cover this shortfall?";
                }
                break;
            case "ONETIME_P_FORM":
                $LumSumCalculatedValue = BotmsgFormulaValue::where('fk_visitor_id', $visitorID)
                    ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
                    ->where('botmsgs_formula.name', 'LUMSUM_CALC')
                    ->where('botmsgs_fomula_values.fk_bot_info_id', $botInfo->id)
                    ->where('botmsgs_fomula_values.status', 1)->get()->first();

                $MONTHLY_INPUT = BotmsgFormulaValue::where('fk_visitor_id', $visitorID)
                    ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
                    ->where('botmsgs_formula.name', 'MONTHLY_INPUT')
                    ->where('botmsgs_fomula_values.fk_bot_info_id', $botInfo->id)
                    ->where('botmsgs_fomula_values.status', 1)->get()->first();

                $PRESENT_VALUE = BotmsgFormulaValue::where('fk_visitor_id', $visitorID)
                    ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
                    ->where('botmsgs_formula.name', 'PRESENT_VALUE')
                    ->where('botmsgs_fomula_values.fk_bot_info_id', $botInfo->id)
                    ->where('botmsgs_fomula_values.status', 1)->get()->first();

                $ONETIME_P_FORM = $LumSumCalculatedValue->value  - ($PRESENT_VALUE->value + ($MONTHLY_INPUT->value * $noOfMonth));
                BotmsgFormula::saveFormulaValue(intval($ONETIME_P_FORM), $botInfo->id,  $visitorID, $botFormula->id);
                $ONETIME_P_FORM = BotmsgFormula::moneyFormatIndia(intval($ONETIME_P_FORM));

                return $ONETIME_P_FORM;
                break;
            case "PRESENT_VALUE":
                // PV = 571759/(1 + 0.13)^ 5
                $Shortfall = BotmsgFormulaValue::where('fk_visitor_id', $visitorID)
                    ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
                    ->where('botmsgs_formula.name', 'SYP_DYNAMIC_SHORTFALL')
                    ->where('botmsgs_fomula_values.fk_bot_info_id', $botInfo->id)
                    ->where('botmsgs_fomula_values.status', 1)->get()->first();
                $PV = $Shortfall->value  / pow(1 + $interstRate->value, $NoOfYear);
                BotmsgFormula::saveFormulaValue(intval($PV), $botInfo->id,  $visitorID, $botFormula->id);
                $PV = BotmsgFormula::moneyFormatIndia(intval($PV));

                return $PV;
                break;

            case "YEARS_PLAN":
                BotmsgFormula::saveFormulaValue($botSavedNoOfyear->value, $botInfo->id,  $visitorID, $botFormula->id);
                return $botSavedNoOfyear->value;
                //break;

            case "ONETIME_LUMSUM_CALC":

                if (isset($currentValue)) {
                    $PresentValue = $currentValue;
                    BotmsgFormula::saveFormulaValue($PresentValue, $botInfo->id,  $visitorID, 19);
                    $ONETIMELumSumValue = $PresentValue * pow(1 + $interstRate->value, $NoOfYear);
                    // save it for furthre calculation
                    BotmsgFormula::saveFormulaValue(intval($ONETIMELumSumValue), $botInfo->id,  $visitorID, $botFormula->id);
                    $ONETIMELumSumValue = BotmsgFormula::moneyFormatIndia(intval($ONETIMELumSumValue));
                    return $ONETIMELumSumValue;
                }

                break;
            case "YEARLY_SHORTFALL":


                $LumSumObj = BotmsgFormulaValue::where('fk_botmsg_formula', 1)->where('fk_visitor_id', $visitorID)->where('fk_bot_info_id', $botInfo->id)->where('status', 1)->first();
                $ONETIMELumSumObj = BotmsgFormulaValue::where('fk_botmsg_formula', 8)->where('fk_visitor_id', $visitorID)->where('fk_bot_info_id', $botInfo->id)->where('status', 1)->first();
                $YEARLY_SHORTFALL = intval($LumSumObj->value - $ONETIMELumSumObj->value);
                BotmsgFormula::saveFormulaValue($YEARLY_SHORTFALL, $botInfo->id,  $visitorID, $botFormula->id);

                // if yearly shortfall is negative we should send a custome message / just like msg id = 87 but we use content of 65 but button of 87.
                if ($YEARLY_SHORTFALL <= 0) {

                    $text =  preg_replace('{{{YEARLY_SHORTFALL}}}', $YEARLY_SHORTFALL, $text);
                    $text =  preg_replace('{{{COVER_TEXT}}}', "Do you want us to call you for execution to make your dream come true ?", $text);

                    $accountInfo = AccountsModel::find($botInfo->account_id);
                    $botVisitor  = Botvisitor::find($visitorID);
                    $contactData = Contacts::find($botVisitor->contact_id);
                    //$text_to_be_sent = Botmessage::where('id', 87)->first();
                    $button_options = Botmessageoption::where('msgs_id', 87)->get();
                    $whatsapp_obj = new WhatsappBotApi($accountInfo->phone_number);
                    $resp_code =  $whatsapp_obj->BotButtonMessage($contactData->phone_number, $text, $button_options);
                    $re =  Botvisitorhistory::saveVisitorHistory($visitorID, 87, $currentValue, '', "", '');
                    exit();
                }
                $YEARLY_SHORTFALL2 = BotmsgFormula::moneyFormatIndia($YEARLY_SHORTFALL);

                return $YEARLY_SHORTFALL;
                break;
            case "COVER_TEXT":
                $YEARLY_SHORTFALL = BotmsgFormulaValue::where('fk_visitor_id', $visitorID)
                    ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
                    ->where('botmsgs_formula.name', 'YEARLY_SHORTFALL')
                    ->where('botmsgs_fomula_values.fk_bot_info_id', $botInfo->id)
                    ->where('botmsgs_fomula_values.status', 1)->get()->first();

                if ($YEARLY_SHORTFALL->value > 0) {
                    BotmsgFormula::saveFormulaValue("Do you want to cover this shortfall?", $botInfo->id,  $visitorID, $botFormula->id);
                    return "Do you want to cover this shortfall?";
                }
                break;
            case "INTERST_PERCENT":
                BotmsgFormula::saveFormulaValue($interstRate->value * 100, $botInfo->id,  $visitorID, $botFormula->id);
                return $interstRate->value * 100;
                break;
            case "ONETIME_SIP_CALCU":
                $LumSumCalculatedValue = BotmsgFormulaValue::where('fk_visitor_id', $visitorID)
                    ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
                    ->where('botmsgs_formula.name', 'YEARLY_SHORTFALL')
                    ->where('botmsgs_fomula_values.fk_bot_info_id', $botInfo->id)
                    ->where('botmsgs_fomula_values.status', 1)->get()->first();
                $noOfMonth = 12 * $NoOfYear;
                $abc = $interstRate->value / 12;
                $P = $LumSumCalculatedValue->value / ((pow(1 + $abc, $noOfMonth) - 1) / $abc) * (1 + $abc);
                BotmsgFormula::saveFormulaValue(intval($P), $botInfo->id,  $visitorID, $botFormula->id);
                $P = BotmsgFormula::moneyFormatIndia(intval($P));
                return $P;
                break;
            case "ONETIME_SAVE":

                $LumSumCalculatedValue = BotmsgFormulaValue::where('fk_visitor_id', $visitorID)
                    ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
                    ->where('botmsgs_formula.name', 'LUMSUM_CALC')
                    ->where('botmsgs_fomula_values.fk_bot_info_id', $botInfo->id)
                    ->where('botmsgs_fomula_values.status', 1)->get()->first();

                $ONETIME_SIP_CALCU = BotmsgFormulaValue::where('fk_visitor_id', $visitorID)
                    ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
                    ->where('botmsgs_formula.name', 'ONETIME_SIP_CALCU')
                    ->where('botmsgs_fomula_values.fk_bot_info_id', $botInfo->id)
                    ->where('botmsgs_fomula_values.status', 1)->get()->first();

                $ONETIME_INPUT = BotmsgFormulaValue::where('fk_visitor_id', $visitorID)
                    ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
                    ->where('botmsgs_formula.name', 'ONETIME_INPUT')
                    ->where('botmsgs_fomula_values.fk_bot_info_id', $botInfo->id)
                    ->where('botmsgs_fomula_values.status', 1)->get()->first();

                $noOfMonth = 12 * $NoOfYear;
                $abc = $interstRate->value / 12;




                $ONETIME_SAVE = ($LumSumCalculatedValue->value -  ($ONETIME_INPUT->value + ($noOfMonth * $ONETIME_SIP_CALCU->value)));
                BotmsgFormula::saveFormulaValue(intval($ONETIME_SAVE), $botInfo->id,  $visitorID, $botFormula->id);
                $ONETIME_SAVE = BotmsgFormula::moneyFormatIndia(intval($ONETIME_SAVE));

                return $ONETIME_SAVE;


                break;
            case "APPOINTMENT_D1":
                $date = NOW();
                $givendate = date('Y-m-d', strtotime($date . ' + 1 days'));
                $givendateandMonth = date('Y-m-d', strtotime($date . ' + 1 days'));
                $date =  BotmsgFormula::processDate($givendate, $givendateandMonth);
                BotmsgFormula::saveFormulaValue($date, $botInfo->id,  $visitorID, $botFormula->id);
                return (date("d/m/Y", strtotime($date)));

                break;
            case "APPOINTMENT_D2":
                $date = NOW();
                $givendate =  BotmsgFormulaValue::where('fk_visitor_id', $visitorID)
                    ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
                    ->where('botmsgs_formula.name', 'APPOINTMENT_D1')
                    ->where('botmsgs_fomula_values.fk_bot_info_id', $botInfo->id)
                    ->where('botmsgs_fomula_values.status', 1)->get()->first();
                $date = $givendate->value;
                $givendate =  date('Y-m-d', strtotime($date . ' + 1 days'));
                $givendateandMonth =  date('Y-m-d', strtotime($date . ' + 1 days'));
                $date =  BotmsgFormula::processDate($givendate, $givendateandMonth);
                BotmsgFormula::saveFormulaValue($date, $botInfo->id,  $visitorID, $botFormula->id);
                return (date("d/m/Y", strtotime($date)));
                break;
            case "APPOINTMENT_D3":
                $date = NOW();
                $givendate =  BotmsgFormulaValue::where('fk_visitor_id', $visitorID)
                    ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
                    ->where('botmsgs_formula.name', 'APPOINTMENT_D2')
                    ->where('botmsgs_fomula_values.fk_bot_info_id', $botInfo->id)
                    ->where('botmsgs_fomula_values.status', 1)->get()->first();
                $date = $givendate->value;
                $givendate =  date('Y-m-d', strtotime($date . ' + 1 days'));
                $givendateandMonth =  date('Y-m-d', strtotime($date . ' + 1 days'));
                $date =  BotmsgFormula::processDate($givendate, $givendateandMonth);
                BotmsgFormula::saveFormulaValue($date, $botInfo->id,  $visitorID, $botFormula->id);
                return (date("d/m/Y", strtotime($date)));
                break;
            case "APPOINTMENT_D4":
                $date = NOW();
                $givendate =  BotmsgFormulaValue::where('fk_visitor_id', $visitorID)
                    ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
                    ->where('botmsgs_formula.name', 'APPOINTMENT_D3')
                    ->where('botmsgs_fomula_values.fk_bot_info_id', $botInfo->id)
                    ->where('botmsgs_fomula_values.status', 1)->get()->first();
                $date = $givendate->value;
                $givendate =  date('Y-m-d', strtotime($date . ' + 1 days'));
                $givendateandMonth =  date('Y-m-d', strtotime($date . ' + 1 days'));
                $date =  BotmsgFormula::processDate($givendate, $givendateandMonth);
                BotmsgFormula::saveFormulaValue($date, $botInfo->id,  $visitorID, $botFormula->id);
                return (date("d/m/Y", strtotime($date)));
                break;
        }
    }
    public static function saveFormulaValue($value, $bot_info_id, $visitor_id, $formula_id)
    {
        $submit_data = array(
            'fk_botmsg_formula' => $formula_id,
            'fk_visitor_id' => $visitor_id,
            'fk_bot_info_id' => $bot_info_id,
            'value' => $value,
            'status' => 1,
            'created_at' => NOW()
        );
        $save = DB::table('botmsgs_fomula_values')->insert($submit_data);
    }
    public static function checkHolidays($date)
    {
        $holidays = array('0' => '01-26', '1' =>  '03-07', '2' => '04-07', '3' => '05-01', '4' => '08-15', '5' => '09-19', '6' => '10-02', '7' => '10-24', '8' => '11-10', '9' => '11-11', '10' => '11-12', '11' => '11-13', '12' => '11-14', '13' => '11-15', '14' => '11-16', '15' => '11-17', '16' => '11-18', '17' => '12-25');
        if (in_array($date, $holidays)) {
            return true;
        } else {
            return false;
        }
    }
    public static function checkifSunday($date)
    {
        $givendate = $date;
        $MyGivenDateIn = strtotime($givendate);
        $ConverDate = date("l", $MyGivenDateIn);
        $ConverDateTomatch = strtolower($ConverDate);
        if (($ConverDateTomatch == "sunday")) {
            return true;
        } else {
            return false;
        }
    }

    public static function moneyFormatIndia($num)
    {
        $explrestunits = "";
        if (strlen($num) > 3) {
            $lastthree = substr($num, strlen($num) - 3, strlen($num));
            $restunits = substr($num, 0, strlen($num) - 3); // extracts the last three digits
            $restunits = (strlen($restunits) % 2 == 1) ? "0" . $restunits : $restunits; // explodes the remaining digits in 2's formats, adds a zero in the beginning to maintain the 2's grouping.
            $expunit = str_split($restunits, 2);
            for ($i = 0; $i < sizeof($expunit); $i++) {
                // creates each of the 2's group and adds a comma to the end
                if ($i == 0) {
                    $explrestunits .= (int)$expunit[$i] . ","; // if is first value , convert into integer
                } else {
                    $explrestunits .= $expunit[$i] . ",";
                }
            }
            $thecash = $explrestunits . $lastthree;
        } else {
            $thecash = $num;
        }
        return $thecash; // writes the final format where $currency is the currency symbol.
    }
    public static function processDate($givendate, $givendateandMonth)
    {

        $checkSunday = BotmsgFormula::checkifSunday($givendate);
        //if there is a sunday in new date
        if ($checkSunday) {

            $givendate =  date('Y-m-d', strtotime($givendate . ' + 1 days'));
            $givendateandMonth =  date('m-d', strtotime($givendate . ' + 1 days'));

            $flag =  BotmsgFormula::checkHolidays($givendateandMonth);
            if ($flag) {
                //after holiday check if there is a sunday
                $givendate =  date('Y-m-d', strtotime($givendate . ' + 1 days'));
                return $givendate;
            } else {
                return $givendate;
            }
        } else {
            //No sunday in new date now check holiday
            $flag =  BotmsgFormula::checkHolidays($givendateandMonth);
            if ($flag) {
                $givendate =  date('Y-m-d', strtotime($givendate . ' + 1 days'));
                // check again if sunday exist in new day
                $checkSunday = BotmsgFormula::checkifSunday($givendate);
                if ($checkSunday) {
                    $givendate =  date('Y-m-d', strtotime($givendate . ' + 1 days'));
                    return $givendate;
                } else {
                    return $givendate;
                }
            } else {
                return $givendate;
            }
        }
        exit();





        $checkSunday = BotmsgFormula::checkifSunday($givendate);

        if ($checkSunday) {

            $givenMonthandDate = date('m-d', strtotime($givendate . ' + 1 days'));
            $givendate = date('y-m-d', strtotime($givendate . ' + 1 days'));
            $flag =  BotmsgFormula::checkHolidays($givenMonthandDate);
            if ($flag) {
                $givendate = date('Y-m-d', strtotime($givendate . ' + 1 days'));
                $checkSunday = BotmsgFormula::checkifSunday($givendate);
                if ($checkSunday) {
                    return date('Y-m-d', strtotime($givendate . ' + 1 days'));
                } else {
                    return $givendate;
                }
            } else {
                return $givendate;
            }
        } else {
            $date = NOW();
            // $givenMonthandDate =  date('Y-m-d', strtotime($date . ' + 1 days'));
            $flag =  BotmsgFormula::checkHolidays($givenMonthandDate);
            if ($flag) {
                $givendate = date('Y-m-d', strtotime($givendate . ' + 1 days'));
                $checkSunday = BotmsgFormula::checkifSunday($givendate);
                if ($checkSunday) {
                    return date('Y-m-d', strtotime($givendate . ' + 1 days'));
                } else {
                    return $givendate;
                }
            } else {
                $checkSunday = BotmsgFormula::checkifSunday($givendate);
                if ($checkSunday) {
                    return date('Y-m-d', strtotime($givendate . ' + 1 days'));
                } else {
                    print_r($givendate);
                    exit();
                    return $givendate;
                }
            }
        }
    }

    public static function dynamicComingValue($coming_answ, $text_message, $visitor_id, $bot_info_id)
    {
        $matches = array();
        $t = preg_match_all('/{{(.*?)\}}/s', $coming_answ, $matches);

        if ($t) {
            $OTP =  BotmsgFormulaValue::where('fk_visitor_id', $visitor_id)
                ->join('botmsgs_formula', 'botmsgs_formula.id', '=', 'botmsgs_fomula_values.fk_botmsg_formula')
                ->where('botmsgs_formula.name', 'OTP')
                ->where('botmsgs_fomula_values.fk_bot_info_id', $bot_info_id)
                ->where('botmsgs_fomula_values.status', 1)->get()->first();

            if ($OTP->value == $text_message) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
    public static function setStatus($visitor_id)
    {
        DB::table('botmsgs_fomula_values')
            ->where('fk_visitor_id', $visitor_id)
            ->update(['status' => 0]);
    }
}
