<?php

namespace App\Models\Users;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use App\Models\Users\Botregion;

class Botmessageoption extends Model
{
    protected $table = 'bot_msgs_options';
    use HasFactory;

    public static function getMsgoptionbymsgID($msg_id)
    {
        $data = Botmessageoption::Select('bot_msgs_options.id', 'bot_msgs_options.msgs_id', 'bot_msgs_options.option_text', 'bot_msgs_options.valid_answer')
            ->where('bot_msgs_options.status', 1)
            ->where('bot_msgs_options.msgs_id', $msg_id)
            ->get();

        return $data;
    }
    public static function getMsgTemplateDetails($msg_id)
    {
        $data = Botmessage::Select('bot_msgs.id', 'bot_msgs.is_template', 'bot_msgs.template_id')
            ->where('bot_msgs.status', 1)
            ->where('bot_msgs.id', $msg_id)
            ->get();

        return $data;
    }

    // this will format the getting text
    public static function formattingMessage($data_options_for_sent, $msgtxt, $msg_type)
    {
        $text = $msgtxt;
        // if message type is button don't format
        if ($msg_type == Botmessage::BUTTONS) {
        } else {
            foreach ($data_options_for_sent as $da_op_sent) {
                // combining text for sent purpose
                //$text = $text . $da_op_sent->option_text;
                //$text = $text . "";
            }
        }

        return $text;
    }

    public static function formattingbuttonMessage($button_options)
    {
        $txt = '';
        foreach ($button_options as $bt_opt) {
            $txt = $txt . '{
                "type": "reply",
                "reply": {
                  "id": "' . $bt_opt->valid_answer . '",
                  "title":"' . $bt_opt->option_text . '" 
                }
              },';
        }
        return $txt;
    }

    public static function formattingInteractivMessage($msg_data_options)
    {
        $txt = '';
        if (sizeof($msg_data_options) == 1) {
            $txt = $txt . '{
                "id": "SECTION_1_ROW_1_ID",
                "title": "SECTION_1_ROW_1_TITLE",
                "description": "SECTION_1_ROW_1_DESCRIPTION"
              }';
        } else {
            $ite = 0;
            for ($i = 0; $i < sizeof($msg_data_options) - 1; $i++) {
                $txt = $txt . '{
                "id": "' . $msg_data_options[$i]->valid_answer . '",
                "title": "' . $msg_data_options[$i]->option_text . '",
                "description": ""
              },';
            }
            $ite = $i;
            $txt = $txt . '{
              "id": "' . $msg_data_options[$ite]->valid_answer . '",
              "title": "' . $msg_data_options[$ite]->option_text . '",
              "description": " "
            }';
        }

        return $txt;
    }

    public static function formattingInteractivProductMessage($msg_data_options)
    {
        $txt = '';
        if (sizeof($msg_data_options) == 1) {
            // if size one need to write here 
        } else {
            $ite = 0;

            for ($i = 0; $i < sizeof($msg_data_options); $i++) {
                // check that select more region message dont go IN
                if (is_numeric($msg_data_options[$i]->option_text)) {

                    $bot_regions = Botregion::where('id', $msg_data_options[$i]->option_text)->get()->first();

                    $txt = $txt .  '{
                        "title":"' . substr($bot_regions->region_name, 0, 24) . '",
                        "rows": [
                            {
                            "id": "' . $msg_data_options[$i]->valid_answer . '",
                            "title": "' . substr($bot_regions->region_name, 0, 24) . '",
                            "description": "' . substr($bot_regions->cities, 0, 74) . '"
                            }
                        ]
                    },';
                } else {
                    $txt = $txt .  '{
                        "title":"' . $msg_data_options[$i]->option_text . '",
                        "rows": [
                            {
                            "id": "' . $msg_data_options[$i]->valid_answer . '",
                            "title": "' . $msg_data_options[$i]->option_text . '",
                            "description": ""
                            }
                        ]
                    },';
                }
            }

            return $txt;
        }
    }
}
