<?php

namespace App\Models\Users;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AccountsModel extends Model
{
    protected $table = 'accounts';
    use HasFactory;

    //get Accounts of a particular company
    public static function getAccounts($company_id)
    {
        $data = AccountsModel::where('company_id', $company_id)
            ->where('status', 1)
            ->get();
        return $data;
    }
    //get Accounts of a particular company
    public static function getAccountsonPoneNumber($phone_number)
    {
        $data = AccountsModel::where('phone_number', $phone_number)
            ->where('status', 1)
            ->get()->first();
        return $data;
    }
}
