<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class Email_helper extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public $data;
    public $subject;
    public $name;
    public $viewName;

    public function __construct($data,$subject,$name,$viewName)
    {
        //
        $this->data = $data;
        $this->subject = $subject;
        $this->name = $name;
        $this->viewName = $viewName;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $address = 'info@200west.com';
        $subject = $this->subject;
        $name = $this->name;

        if($subject == 'Birthday Wish'){
            return $this->view($this->viewName)
            ->from($address, $name)
            ->replyTo($address, $name)
            ->subject($subject)
            ->with([ 'test_message' => $this->data ]);
        }else{
            return $this->view($this->viewName)
            ->cc($address, $name)
            ->from($address, $name)
            ->replyTo($address, $name)
            ->subject($subject)
            ->with([ 'test_message' => $this->data ]);
        }
    }
}
