<?php

namespace App\Imports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\SkipsEmptyRows;
use App\Models\Users\Broadcast;
use App\Models\WhatsappApi;

class ReadAttachment implements WithStartRow, SkipsEmptyRows, ToModel
{
    public $template_name;
    public $lang;
    public $flage;
    public $componenets;
    public $broadcast_id;
    private $rows = 0;

    function __construct($template_name, $lang, $flage, $componenets, $file, $template_metaid, $broadcast_id)
    {

        $this->lang = $lang;
        $this->flage = $flage;
        $this->componenets = $componenets;
        $this->template_name = $template_name;
        $this->template_metaid = $template_metaid;
        $this->file = $file;
        $this->broadcast_id = $broadcast_id;
    }
    // skip the header and start from 2nd row
    public function startRow(): int
    {
        return 2;
    }
    /**
     * @param Collection $collection
     */
    public function collection(Collection $collection)
    {
        //
    }
    public function model(array $row)
    {

        if ($this->flage == 'count rows') {
            ++$this->rows;
        } else {
            $wa_obj = new WhatsappApi();
            $message = '';
            if ($this->componenets == 0) {

                $message = $wa_obj->gasslewithoutParams($this->template_name, $this->lang, $row[0], 0, $this->template_metaid, $this->file, $this->broadcast_id);
            } else {
                $message = $wa_obj->gasslewithParams($this->template_name, $this->lang, $row, $this->componenets, $this->template_metaid, $this->file, $this->broadcast_id);
            }
        }
        //return $message;
    }
    public function getRowCount(): int
    {
        return $this->rows;
    }
}
