<?php

namespace App\Http\Controllers\Auth\User;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Str;
use Carbon\Carbon;
use App\Mail\Announcement_Email_helper;
use Illuminate\Support\Facades\Mail;




class LoginController extends Controller
{
   /*
   |--------------------------------------------------------------------------
   | Login Controller
   |--------------------------------------------------------------------------
   |
   | This controller handles authenticating users for the application and
   | redirecting them to your home screen. The controller uses a trait
   | to conveniently provide its functionality to your applications.
   |
   */
   use AuthenticatesUsers;

   /**
    * Where to redirect users after login.
    *
    * @var string
    */
   // protected $redirectTo = '/home';
   public function __construct()
   {
      $this->middleware('guest:user')->except('logout');
   }

   /**
    * Display a listing of the resource.
    *
    * @return \Illuminate\Http\Response
    */
   public function login()
   {
      return view('auth.user.login');
   }

   public function loginUser(Request $request)
   {
      // Validate the form data
      $this->validate($request, [
         'email' => 'required',
         'password' => 'required'
      ]);

      // Attempt to log the user in
      if (Auth::guard('user')->attempt(['email' => $request->email, 'password' => $request->password, 'status' => 1], $request->remember)) {
         // if successful, then redirect to their intended location
         // save the  timezone in users table
         // DB::table('users')
         //    ->where('id', Auth::user()->id)
         //    ->update(['timezone' => $request->timezone]);
         return redirect()->route('user.dashboard');
      }
      // if unsuccessful, then redirect back to the login with the form data
      $errors = ['email' => 'Sorry! Wrong email or password '];
      return redirect()->back()->withInput($request->only('email', 'remember'))->withErrors($errors);
   }

public function resetPassword(){
   // print_r("reset");
   // exit;
   return view('auth.passwords.email');
}

    public function resetPasswordFunction(Request $request)
    {
        $request->validate([
            'email' => 'required|email|exists:users',
        ]);

        $token = Str::random(40);

        DB::table('password_resets')->insert(
            ['email' => $request->email, 'token' => $token, 'created_at' => Carbon::now()]
        );

        // Mail::send('auth.passwords.resetPassword', ['token' => $token], function ($message) use ($request) {
        //     $message->to($request->email);
        //     $message->subject('Reset Password Notification');
        // });
        $this->sendEmail('naeemakram213@gmail.com', 'Reset Password Notification',$token, "abc", "","");


        return back()->with('message', 'We have e-mailed your password reset link!');
    }

   public function logout()
   {
      Auth::guard('user')->logout();
      return redirect()->route('user.auth.login');
   }


    private function sendEmail($to, $sub, $token, $name, $message, $fileName)
    {

        $data = [
            'message' => $message,
            'subject' => $sub,
            'token'=> $token
        ];
        // $emails = ['naeemakram213@gmail.com', 'na6574113@gmail.com','naeem.ak.113@gmail.com'];
        Mail::to($to)->send(new Announcement_Email_helper($data, $sub, $name, 'auth.user.resetPassword', $fileName));
    }
}
