<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Users\Botvisitorhistory;
use App\Models\Users\Botvisitor;
use App\Models\Users\Contacts;
use App\Models\Users\BotExternalAction;
use App\Models\Users\Botinfo;
use App\Models\Users\AccountsModel;
use Illuminate\Support\Facades\Log;
use App\Models\Users\Botmsgreminder;
use App\Models\Users\BotmsgFormula;

class BotReminder2 extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'reminder:two';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        //Log::info("Run command!");

        $data = Botvisitorhistory::where('bot_visitors_history.status', 1)
            ->join('bot_visitors', 'bot_visitors_history.visitor_id', '=', 'bot_visitors.id')
            ->join('contacts', 'contacts.id', '=', 'bot_visitors.contact_id')
            ->join('accounts', 'contacts.account_id', '=', 'accounts.id')
            ->where('accounts.phone_number', '918956453344')
            ->where('contacts.account_id', 10)
            ->where('accounts.status', 1)
            ->where('bot_visitors.status',  1)
            ->where('msg_id', '!=', 75)
            ->where('msg_id', '!=', 73)
            ->groupBy('bot_visitors_history.visitor_id')
            ->get();

        //print_r($data->count());
        foreach ($data as $da) {

            // it means there is first reminder already sent to the bot user
            $botreminder = Botmsgreminder::select('*')->where('visitor_id', $da->visitor_id)->where('status', 1)->latest()->first();
            $minute = abs(strtotime(NOW()->toDateTimeString()) - strtotime($botreminder->created_at->toDateTimeString())) / (60);

            print_r("after 10 minutes it will go::: " . $minute);
            //if morethen 30 minutes has gone and the first reminder already sent
            if ($minute >= 10 && $botreminder->count()) {

                $bot_visitor = Botvisitor::find($da->visitor_id);
                $contact = Contacts::find($bot_visitor->contact_id);
                $bot_info = Botinfo::find($bot_visitor->fk_bot_info);
                $account_info = AccountsModel::find($bot_info->account_id);
                BotmsgFormula::setStatus($da->visitor_id);
                Botvisitor::updateVisitor($contact->id);
                Botvisitorhistory::updateVisitorHistory($da->visitor_id);
                BotExternalAction::sendcautionMessage($contact->phone_number, $account_info->phone_number, "Thank you for contacting  MASS Investments");
            }
        }
    }
}
