<?php

namespace App\Console\Commands;

use App\Models\Users\Botmsgreminder;
use Illuminate\Console\Command;
use App\Models\Users\Botvisitorhistory;
use App\Models\Users\Botvisitor;
use App\Models\Users\Contacts;
use App\Models\Users\BotExternalAction;
use App\Models\Users\Botinfo;
use App\Models\Users\AccountsModel;
use App\Models\Users\Botreminder as UsersBotreminder;
use CreateBotVisitorsReasult;
use Illuminate\Support\Facades\Log;

class BotReminder extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'reminder:one';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        //Log::info("Run command!");
        $data = Botvisitorhistory::select('bot_visitors_history.id', 'bot_visitors_history.visitor_id', 'bot_visitors_history.value', 'bot_visitors_history.text', 'bot_visitors_history.msg_id', 'bot_visitors_history.created_at', 'bot_visitors.id', 'bot_visitors.status')
            ->join('bot_visitors', 'bot_visitors_history.visitor_id', '=', 'bot_visitors.id')
            ->join('contacts', 'contacts.id', '=', 'bot_visitors.contact_id')
            ->join('accounts', 'contacts.account_id', '=', 'accounts.id')
            ->where('bot_visitors_history.status', 1)
            ->where('accounts.phone_number', '918956453344')
            ->where('contacts.account_id', 10)
            ->where('bot_visitors.status',  1)
            ->where('bot_visitors_history.msg_id', '!=', 75)
            // ->where('bot_visitors_history.msg_id', '=', 73)
            ->groupBy('bot_visitors_history.visitor_id')
            ->get();

        foreach ($data as $da) {

            $check = Botvisitorhistory::where('status', 1)
                ->where('msg_id', 75)
                ->orwhere('msg_id', 73)
                ->where('visitor_id', '=', $da->visitor_id)
                ->get();

            // check if first reminder already not there
            $botreminder = Botmsgreminder::where('visitor_id', $da->visitor_id)->where('status', 1)->get();
            //print_r($check->count());
            //exit();
            if (!$check->count() && !$botreminder->count()) {
                $latest_created_at = Botvisitorhistory::where('visitor_id', $da->visitor_id)->where('status', 1)->latest()->first();
                $minute = abs(strtotime(NOW()) - strtotime($latest_created_at->created_at)) / (60);

                if ($minute >= 5 && !$check->count()) {

                    $bot_visitor = Botvisitor::find($da->visitor_id);
                    $contact = Contacts::find($bot_visitor->contact_id);
                    $bot_info = Botinfo::find($bot_visitor->fk_bot_info);
                    $account_info = AccountsModel::find($bot_info->account_id);
                    Botmsgreminder::insertData($da->visitor_id, 1);
                    //$re =  Botvisitorhistory::saveVisitorHistory($da->visitor_id, 78, 'reminder1', '', "", '');
                    BotExternalAction::sendcautionMessage($contact->phone_number, $account_info->phone_number, "We are waiting for your reply!");
                }
            }
        }
    }
}
